/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import com.google.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.FullResponseHandler;
import org.apache.hive.druid.com.metamx.http.client.response.FullResponseHolder;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerConfig;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;

@ManageLifecycle
public class CoordinatorRuleManager {
    private static final Logger log = new Logger(CoordinatorRuleManager.class);
    private final HttpClient httpClient;
    private final ObjectMapper jsonMapper;
    private final Supplier<TieredBrokerConfig> config;
    private final ServerDiscoverySelector selector;
    private final FullResponseHandler responseHandler;
    private final AtomicReference<ConcurrentHashMap<String, List<Rule>>> rules;
    private volatile ScheduledExecutorService exec;
    private final Object lock = new Object();
    private volatile boolean started = false;

    @Inject
    public CoordinatorRuleManager(@Global HttpClient httpClient, @Json ObjectMapper jsonMapper, Supplier<TieredBrokerConfig> config, ServerDiscoverySelector selector) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.selector = selector;
        this.responseHandler = new FullResponseHandler(Charsets.UTF_8);
        this.rules = new AtomicReference(new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.exec = Execs.scheduledSingleThreaded("CoordinatorRuleManager-Exec--%d");
            ScheduledExecutors.scheduleWithFixedDelay(this.exec, new Duration(0L), this.config.get().getPollPeriod().toStandardDuration(), new Runnable(){

                @Override
                public void run() {
                    CoordinatorRuleManager.this.poll();
                }
            });
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.rules.set(new ConcurrentHashMap());
            this.started = false;
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void poll() {
        try {
            String url = this.getRuleURL();
            if (url == null) {
                return;
            }
            FullResponseHolder response = (FullResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), this.responseHandler).get();
            if (response.getStatus().equals(HttpResponseStatus.FOUND)) {
                url = response.getResponse().headers().get("Location");
                log.info("Redirecting rule request to [%s]", url);
                response = (FullResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), this.responseHandler).get();
            }
            ConcurrentHashMap<String, List<Rule>> newRules = new ConcurrentHashMap<String, List<Rule>>(this.jsonMapper.readValue(response.getContent(), new TypeReference<Map<String, List<Rule>>>(){}));
            log.info("Got [%,d] rules", ((ConcurrentHashMap.CollectionView)((Object)newRules.keySet())).size());
            this.rules.set(newRules);
        }
        catch (Exception e) {
            log.error(e, "Exception while polling for rules", new Object[0]);
        }
    }

    public List<Rule> getRulesWithDefault(String dataSource) {
        ArrayList<Rule> retVal = Lists.newArrayList();
        Map theRules = this.rules.get();
        if (theRules.get(dataSource) != null) {
            retVal.addAll((Collection)theRules.get(dataSource));
        }
        if (theRules.get(this.config.get().getDefaultRule()) != null) {
            retVal.addAll((Collection)theRules.get(this.config.get().getDefaultRule()));
        }
        return retVal;
    }

    private String getRuleURL() throws URISyntaxException {
        Server server = this.selector.pick();
        if (server == null) {
            log.error("No instances found for [%s]!", this.config.get().getCoordinatorServiceName());
            return null;
        }
        return new URI(server.getScheme(), null, server.getAddress(), server.getPort(), this.config.get().getRulesEndpoint(), null, null).toString();
    }
}

