/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.metrics;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.metrics.JvmCpuMonitor;
import org.apache.hive.druid.com.metamx.metrics.JvmMonitor;
import org.apache.hive.druid.com.metamx.metrics.Monitor;
import org.apache.hive.druid.com.metamx.metrics.MonitorScheduler;
import org.apache.hive.druid.com.metamx.metrics.SysMonitor;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.guice.DruidBinders;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.query.ExecutorServiceMonitor;
import org.apache.hive.druid.io.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.hive.druid.io.druid.server.metrics.DruidMonitorSchedulerConfig;
import org.apache.hive.druid.io.druid.server.metrics.EventReceiverFirehoseRegister;
import org.apache.hive.druid.io.druid.server.metrics.MonitorsConfig;

public class MetricsModule
implements Module {
    private static final Logger log = new Logger(MetricsModule.class);

    public static void register(Binder binder, Class<? extends Monitor> monitorClazz) {
        DruidBinders.metricMonitorBinder(binder).addBinding().toInstance(monitorClazz);
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.monitoring", DruidMonitorSchedulerConfig.class);
        JsonConfigProvider.bind(binder, "druid.monitoring", MonitorsConfig.class);
        DruidBinders.metricMonitorBinder(binder);
        binder.bind(DataSourceTaskIdHolder.class).in(LazySingleton.class);
        binder.bind(EventReceiverFirehoseRegister.class).in(LazySingleton.class);
        binder.bind(ExecutorServiceMonitor.class).in(LazySingleton.class);
        binder.bind(Key.get(MonitorScheduler.class, (Annotation)Names.named((String)"ForTheEagerness"))).to(MonitorScheduler.class).asEagerSingleton();
    }

    @Provides
    @ManageLifecycle
    public MonitorScheduler getMonitorScheduler(Supplier<DruidMonitorSchedulerConfig> config, MonitorsConfig monitorsConfig, Set<Class<? extends Monitor>> monitorSet, ServiceEmitter emitter, Injector injector) {
        ArrayList<Monitor> monitors = Lists.newArrayList();
        for (Class<? extends Monitor> monitorClass : Iterables.concat(monitorsConfig.getMonitors(), monitorSet)) {
            Monitor monitor = (Monitor)injector.getInstance(monitorClass);
            log.info("Adding monitor[%s]", monitor);
            monitors.add(monitor);
        }
        return new MonitorScheduler(config.get(), Execs.scheduledSingleThreaded("MonitorScheduler-%s"), emitter, monitors);
    }

    @Provides
    @ManageLifecycle
    public JvmMonitor getJvmMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new JvmMonitor(MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId()));
    }

    @Provides
    @ManageLifecycle
    public JvmCpuMonitor getJvmCpuMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new JvmCpuMonitor(MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId()));
    }

    @Provides
    @ManageLifecycle
    public SysMonitor getSysMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new SysMonitor(MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId()));
    }
}

