/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination.broker;

import com.google.inject.Inject;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.client.FilteredServerInventoryView;
import org.apache.hive.druid.io.druid.client.ServerView;
import org.apache.hive.druid.io.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.server.DruidNode;

@ManageLifecycle
public class DruidBroker {
    private final DruidNode self;
    private final ServiceAnnouncer serviceAnnouncer;
    private volatile boolean started = false;

    @Inject
    public DruidBroker(FilteredServerInventoryView serverInventoryView, final @Self DruidNode self, final ServiceAnnouncer serviceAnnouncer) {
        this.self = self;
        this.serviceAnnouncer = serviceAnnouncer;
        serverInventoryView.registerSegmentCallback(MoreExecutors.sameThreadExecutor(), new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                serviceAnnouncer.announce(self);
                return ServerView.CallbackAction.UNREGISTER;
            }
        }, Predicates.alwaysFalse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        DruidNode druidNode = this.self;
        synchronized (druidNode) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        DruidNode druidNode = this.self;
        synchronized (druidNode) {
            if (!this.started) {
                return;
            }
            this.serviceAnnouncer.unannounce(this.self);
            this.started = false;
        }
    }
}

