/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.MapMaker;
import org.apache.hive.druid.com.google.common.io.CountingOutputStream;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.query.DruidMetrics;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.server.QueryManager;
import org.apache.hive.druid.io.druid.server.QueryStats;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;
import org.joda.time.DateTime;

@Path(value="/druid/v2/")
public class QueryResource {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    protected static final int RESPONSE_CTX_HEADER_LEN_LIMIT = 7168;
    protected final QueryToolChestWarehouse warehouse;
    protected final ServerConfig config;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final QuerySegmentWalker texasRanger;
    protected final ServiceEmitter emitter;
    protected final RequestLogger requestLogger;
    protected final QueryManager queryManager;
    protected final AuthConfig authConfig;

    @Inject
    public QueryResource(QueryToolChestWarehouse warehouse, ServerConfig config, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QuerySegmentWalker texasRanger, ServiceEmitter emitter, RequestLogger requestLogger, QueryManager queryManager, AuthConfig authConfig) {
        this.warehouse = warehouse;
        this.config = config;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.texasRanger = texasRanger;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.queryManager = queryManager;
        this.authConfig = authConfig;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getServer(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", queryId);
        }
        if (this.authConfig.isEnabled()) {
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull(authorizationInfo, "Security is enabled but no authorization info found in the request");
            Set<String> datasources = this.queryManager.getQueryDatasources(queryId);
            if (datasources == null) {
                log.warn("QueryId [%s] not registered with QueryManager, cannot cancel", queryId);
            } else {
                for (String dataSource : datasources) {
                    Access authResult = authorizationInfo.isAuthorized(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE);
                    if (authResult.isAllowed()) continue;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).header("Access-Check-Result", (Object)authResult).build();
                }
            }
        }
        this.queryManager.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, final @Context HttpServletRequest req) throws IOException {
        final long start = System.currentTimeMillis();
        Query query = null;
        QueryToolChest toolChest = null;
        String queryId = null;
        ResponseContext context = this.createContext(req.getContentType(), pretty != null);
        String currThreadName = Thread.currentThread().getName();
        try {
            ConcurrentMap<String, Object> responseContext;
            Sequence res;
            query = context.getObjectMapper().readValue(in, Query.class);
            queryId = query.getId();
            if (queryId == null) {
                queryId = UUID.randomUUID().toString();
                query = query.withId(queryId);
            }
            if (query.getContextValue("timeout") == null) {
                query = query.withOverriddenContext(ImmutableMap.of("timeout", this.config.getMaxIdleTime().toStandardDuration().getMillis()));
            }
            toolChest = this.warehouse.getToolChest(query);
            Thread.currentThread().setName(String.format("%s[%s_%s_%s]", currThreadName, query.getType(), query.getDataSource(), queryId));
            if (log.isDebugEnabled()) {
                log.debug("Got query [%s]", query);
            }
            if (this.authConfig.isEnabled()) {
                AuthorizationInfo authorizationInfo = (AuthorizationInfo)req.getAttribute("Druid-Auth-Token");
                if (authorizationInfo != null) {
                    for (String dataSource : query.getDataSource().getNames()) {
                        Access authResult = authorizationInfo.isAuthorized(new Resource(dataSource, ResourceType.DATASOURCE), Action.READ);
                        if (authResult.isAllowed()) continue;
                        Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).header("Access-Check-Result", (Object)authResult).build();
                        return response;
                    }
                } else {
                    throw new ISE("WTF?! Security is enabled but no authorization info found in the request", new Object[0]);
                }
            }
            Sequence results = (res = query.run(this.texasRanger, responseContext = new MapMaker().makeMap())) == null ? Sequences.empty() : res;
            final Yielder<Object> yielder = results.toYielder(null, new YieldingAccumulator(){

                public Object accumulate(Object accumulated, Object in) {
                    this.yield();
                    return in;
                }
            });
            try {
                final Query theQuery = query;
                final QueryToolChest theToolChest = toolChest;
                final ObjectWriter jsonWriter = context.newOutputWriter();
                Response.ResponseBuilder builder = Response.ok((Object)new StreamingOutput(){

                    public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                        CountingOutputStream os = new CountingOutputStream(outputStream);
                        jsonWriter.writeValue(os, (Object)yielder);
                        os.flush();
                        os.close();
                        long queryTime = System.currentTimeMillis() - start;
                        QueryResource.this.emitter.emit(DruidMetrics.makeQueryTimeMetric(theToolChest, QueryResource.this.jsonMapper, theQuery, req.getRemoteAddr()).setDimension("success", "true").build("query/time", queryTime));
                        QueryResource.this.emitter.emit(DruidMetrics.makeQueryTimeMetric(theToolChest, QueryResource.this.jsonMapper, theQuery, req.getRemoteAddr()).build("query/bytes", os.getCount()));
                        QueryResource.this.requestLogger.log(new RequestLogLine(new DateTime(start), req.getRemoteAddr(), theQuery, new QueryStats(ImmutableMap.of("query/time", queryTime, "query/bytes", os.getCount(), "success", true))));
                    }
                }, (String)context.getContentType()).header("X-Druid-Query-Id", (Object)queryId);
                String responseCtxString = this.jsonMapper.writeValueAsString(responseContext);
                if (responseCtxString.length() > 7168) {
                    log.warn("Response Context truncated for id [%s] . Full context is [%s].", queryId, responseCtxString);
                    responseCtxString = responseCtxString.substring(0, 7168);
                }
                Response response = builder.header("X-Druid-Response-Context", (Object)responseCtxString).build();
                return response;
            }
            catch (Exception e) {
                try {
                    yielder.close();
                    throw Throwables.propagate(e);
                }
                catch (QueryInterruptedException e2) {
                    try {
                        log.info("%s [%s]", e2.getMessage(), queryId);
                        long queryTime = System.currentTimeMillis() - start;
                        this.emitter.emit(DruidMetrics.makeQueryTimeMetric(toolChest, this.jsonMapper, query, req.getRemoteAddr()).setDimension("success", "false").build("query/time", queryTime));
                        this.requestLogger.log(new RequestLogLine(new DateTime(start), req.getRemoteAddr(), query, new QueryStats(ImmutableMap.of("query/time", queryTime, "success", false, "interrupted", true, "reason", e2.toString()))));
                    }
                    catch (Exception e22) {
                        log.error(e22, "Unable to log query [%s]!", query);
                    }
                    Response e22 = context.gotError(e2);
                    return e22;
                }
                catch (Exception e3) {
                    String queryString = query == null ? "unparsable query" : query.toString();
                    log.warn(e3, "Exception occurred on request [%s]", queryString);
                    try {
                        long queryTime = System.currentTimeMillis() - start;
                        this.emitter.emit(DruidMetrics.makeQueryTimeMetric(toolChest, this.jsonMapper, query, req.getRemoteAddr()).setDimension("success", "false").build("query/time", queryTime));
                        this.requestLogger.log(new RequestLogLine(new DateTime(start), req.getRemoteAddr(), query, new QueryStats(ImmutableMap.of("query/time", queryTime, "success", false, "exception", e3.toString()))));
                    }
                    catch (Exception e2) {
                        log.error(e2, "Unable to log query [%s]!", queryString);
                    }
                    log.makeAlert(e3, "Exception handling request", new Object[0]).addData("exception", e3.toString()).addData("query", queryString).addData("peer", req.getRemoteAddr()).emit();
                    Response response = context.gotError(e3);
                    return response;
                }
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    protected ResponseContext createContext(String requestType, boolean pretty) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType) || APPLICATION_SMILE.equals(requestType);
        String contentType = isSmile ? "application/x-jackson-smile" : "application/json";
        return new ResponseContext(contentType, isSmile ? this.smileMapper : this.jsonMapper, pretty);
    }

    protected static class ResponseContext {
        private final String contentType;
        private final ObjectMapper inputMapper;
        private final boolean isPretty;

        ResponseContext(String contentType, ObjectMapper inputMapper, boolean isPretty) {
            this.contentType = contentType;
            this.inputMapper = inputMapper;
            this.isPretty = isPretty;
        }

        String getContentType() {
            return this.contentType;
        }

        public ObjectMapper getObjectMapper() {
            return this.inputMapper;
        }

        ObjectWriter newOutputWriter() {
            return this.isPretty ? this.inputMapper.writerWithDefaultPrettyPrinter() : this.inputMapper.writer();
        }

        Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter().writeValueAsString(object), (String)this.contentType).build();
        }

        Response gotError(Exception e) throws IOException {
            return Response.serverError().type(this.contentType).entity((Object)this.newOutputWriter().writeValueAsBytes(QueryInterruptedException.wrapIfNeeded(e))).build();
        }
    }
}

