/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.File;
import java.io.IOException;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.MetricColumnSerializer;
import org.apache.hive.druid.io.druid.segment.MetricHolder;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;

public class ComplexMetricColumnSerializer
implements MetricColumnSerializer {
    private final String metricName;
    private final ComplexMetricSerde serde;
    private final IOPeon ioPeon;
    private final File outDir;
    private GenericIndexedWriter writer;

    public ComplexMetricColumnSerializer(String metricName, File outDir, IOPeon ioPeon, ComplexMetricSerde serde) {
        this.metricName = metricName;
        this.serde = serde;
        this.ioPeon = ioPeon;
        this.outDir = outDir;
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.ioPeon, String.format("%s_%s", this.metricName, this.outDir.getName()), this.serde.getObjectStrategy());
        this.writer.open();
    }

    @Override
    public void serialize(Object agg) throws IOException {
        this.writer.write(agg);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        File outFile = IndexIO.makeMetricFile(this.outDir, this.metricName, IndexIO.BYTE_ORDER);
        outFile.delete();
        MetricHolder.writeComplexMetric(Files.newOutputStreamSupplier(outFile, true), this.metricName, this.serde.getTypeName(), this.writer);
        IndexIO.checkFileSize(outFile);
        this.writer = null;
    }
}

