/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.plumber;

import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.guice.annotations.Processing;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.FlushingPlumber;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.Plumber;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;
import org.joda.time.Duration;

public class FlushingPlumberSchool
extends RealtimePlumberSchool {
    private static final Duration defaultFlushDuration = new Duration((Object)"PT1H");
    private final Duration flushDuration;
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ExecutorService queryExecutorService;
    private final IndexMerger indexMerger;
    private final IndexMergerV9 indexMergerV9;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final ObjectMapper objectMapper;

    @JsonCreator
    public FlushingPlumberSchool(@JsonProperty(value="flushDuration") Duration flushDuration, @JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject @Processing ExecutorService queryExecutorService, @JacksonInject IndexMerger indexMerger, @JacksonInject IndexMergerV9 indexMergerV9, @JacksonInject IndexIO indexIO, @JacksonInject Cache cache, @JacksonInject CacheConfig cacheConfig, @JacksonInject ObjectMapper objectMapper) {
        super(emitter, conglomerate, null, segmentAnnouncer, null, null, queryExecutorService, indexMerger, indexMergerV9, indexIO, cache, cacheConfig, objectMapper);
        this.flushDuration = flushDuration == null ? defaultFlushDuration : flushDuration;
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryExecutorService = queryExecutorService;
        this.indexMerger = Preconditions.checkNotNull(indexMerger, "Null IndexMerger");
        this.indexMergerV9 = Preconditions.checkNotNull(indexMergerV9, "Null IndexMergerV9");
        this.indexIO = Preconditions.checkNotNull(indexIO, "Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.objectMapper = objectMapper;
    }

    @Override
    public Plumber findPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        this.verifyState();
        return new FlushingPlumber(this.flushDuration, schema, config, metrics, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryExecutorService, config.getBuildV9Directly() != false ? this.indexMergerV9 : this.indexMerger, this.indexIO, this.cache, this.cacheConfig, this.objectMapper);
    }

    private void verifyState() {
        Preconditions.checkNotNull(this.conglomerate, "must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull(this.segmentAnnouncer, "must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull(this.emitter, "must specify a serviceEmitter to do this action.");
    }
}

