/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.com.metamx.metrics.MonitorUtils;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartment;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartmentMetrics;

public class RealtimeMetricsMonitor
extends AbstractMonitor {
    private static final EmittingLogger log = new EmittingLogger(RealtimeMetricsMonitor.class);
    private final Map<FireDepartment, FireDepartmentMetrics> previousValues;
    private final List<FireDepartment> fireDepartments;
    private final Map<String, String[]> dimensions;

    @Inject
    public RealtimeMetricsMonitor(List<FireDepartment> fireDepartments) {
        this(fireDepartments, ImmutableMap.of());
    }

    public RealtimeMetricsMonitor(List<FireDepartment> fireDepartments, Map<String, String[]> dimensions) {
        this.fireDepartments = fireDepartments;
        this.previousValues = Maps.newHashMap();
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        for (FireDepartment fireDepartment : this.fireDepartments) {
            FireDepartmentMetrics metrics = fireDepartment.getMetrics().snapshot();
            FireDepartmentMetrics previous = this.previousValues.get(fireDepartment);
            if (previous == null) {
                previous = new FireDepartmentMetrics();
            }
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", fireDepartment.getDataSchema().getDataSource());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            long thrownAway = metrics.thrownAway() - previous.thrownAway();
            if (thrownAway > 0L) {
                log.warn("[%,d] events thrown away because they are outside the window period!", thrownAway);
            }
            emitter.emit(builder.build("ingest/events/thrownAway", thrownAway));
            long unparseable = metrics.unparseable() - previous.unparseable();
            if (unparseable > 0L) {
                log.error("[%,d] Unparseable events! Turn on debug logging to see exception stack trace.", unparseable);
            }
            emitter.emit(builder.build("ingest/events/unparseable", unparseable));
            emitter.emit(builder.build("ingest/events/processed", metrics.processed() - previous.processed()));
            emitter.emit(builder.build("ingest/rows/output", metrics.rowOutput() - previous.rowOutput()));
            emitter.emit(builder.build("ingest/persists/count", metrics.numPersists() - previous.numPersists()));
            emitter.emit(builder.build("ingest/persists/time", metrics.persistTimeMillis() - previous.persistTimeMillis()));
            emitter.emit(builder.build("ingest/persists/cpu", metrics.persistCpuTime() - previous.persistCpuTime()));
            emitter.emit(builder.build("ingest/persists/backPressure", metrics.persistBackPressureMillis() - previous.persistBackPressureMillis()));
            emitter.emit(builder.build("ingest/persists/failed", metrics.failedPersists() - previous.failedPersists()));
            emitter.emit(builder.build("ingest/handoff/failed", metrics.failedHandoffs() - previous.failedHandoffs()));
            emitter.emit(builder.build("ingest/merge/time", metrics.mergeTimeMillis() - previous.mergeTimeMillis()));
            emitter.emit(builder.build("ingest/merge/cpu", metrics.mergeCpuTime() - previous.mergeCpuTime()));
            emitter.emit(builder.build("ingest/handoff/count", metrics.handOffCount() - previous.handOffCount()));
            this.previousValues.put(fireDepartment, metrics);
        }
        return true;
    }
}

