/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.segment.loading.StorageLocationConfig;
import org.hibernate.validator.constraints.NotEmpty;

public class SegmentLoaderConfig {
    @JsonProperty
    @NotEmpty
    private List<StorageLocationConfig> locations = null;
    @JsonProperty(value="deleteOnRemove")
    private boolean deleteOnRemove = true;
    @JsonProperty(value="dropSegmentDelayMillis")
    private int dropSegmentDelayMillis = 30000;
    @JsonProperty(value="announceIntervalMillis")
    private int announceIntervalMillis = 0;
    @JsonProperty(value="numLoadingThreads")
    private int numLoadingThreads = 1;
    @JsonProperty(value="numBootstrapThreads")
    private Integer numBootstrapThreads = null;
    @JsonProperty
    private File infoDir = null;

    public List<StorageLocationConfig> getLocations() {
        return this.locations;
    }

    public boolean isDeleteOnRemove() {
        return this.deleteOnRemove;
    }

    public int getDropSegmentDelayMillis() {
        return this.dropSegmentDelayMillis;
    }

    public int getAnnounceIntervalMillis() {
        return this.announceIntervalMillis;
    }

    public int getNumLoadingThreads() {
        return this.numLoadingThreads;
    }

    public int getNumBootstrapThreads() {
        return this.numBootstrapThreads == null ? this.numLoadingThreads : this.numBootstrapThreads;
    }

    public File getInfoDir() {
        if (this.infoDir == null) {
            this.infoDir = new File(this.locations.get(0).getPath(), "info_dir");
        }
        return this.infoDir;
    }

    public SegmentLoaderConfig withLocations(List<StorageLocationConfig> locations) {
        SegmentLoaderConfig retVal = new SegmentLoaderConfig();
        retVal.locations = Lists.newArrayList(locations);
        retVal.deleteOnRemove = this.deleteOnRemove;
        retVal.infoDir = this.infoDir;
        return retVal;
    }

    public String toString() {
        return "SegmentLoaderConfig{locations=" + this.locations + ", deleteOnRemove=" + this.deleteOnRemove + ", dropSegmentDelayMillis=" + this.dropSegmentDelayMillis + ", infoDir=" + this.infoDir + '}';
    }
}

