/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.RetryUtils;
import org.apache.hive.druid.io.druid.data.SearchableVersionedDataFinder;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentPuller;

public class LocalFileTimestampVersionFinder
extends LocalDataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    public static final String URI_SCHEME = "file";

    private URI mostRecentInDir(Path dir, final Pattern pattern) throws IOException {
        long latestModified = Long.MIN_VALUE;
        URI latest = null;
        for (File file : dir.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.isFile() && (pattern == null || pattern.matcher(pathname.getName()).matches());
            }
        })) {
            long thisModified = file.lastModified();
            if (thisModified < latestModified) continue;
            latestModified = thisModified;
            latest = file.toURI();
        }
        return latest;
    }

    @Override
    public URI getLatestVersion(URI uri, final @Nullable Pattern pattern) {
        final File file = new File(uri);
        try {
            return RetryUtils.retry(new Callable<URI>(){

                @Override
                public URI call() throws Exception {
                    return LocalFileTimestampVersionFinder.this.mostRecentInDir(file.isDirectory() ? file.toPath() : file.getParentFile().toPath(), pattern);
                }
            }, this.shouldRetryPredicate(), 3);
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                return null;
            }
            throw Throwables.propagate(e);
        }
    }

    @Override
    public Class<URI> getDataDescriptorClass() {
        return URI.class;
    }
}

