/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.BooleanFilter;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.RowOffsetMatcherFactory;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;

public class OrFilter
implements BooleanFilter {
    private static final Joiner OR_JOINER = Joiner.on(" || ");
    private final List<Filter> filters;

    public OrFilter(List<Filter> filters) {
        if (filters.size() == 0) {
            throw new IllegalArgumentException("Can't construct empty OrFilter (the universe does not exist)");
        }
        this.filters = filters;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getBitmapIndex(selector);
        }
        ArrayList<ImmutableBitmap> bitmaps = Lists.newArrayList();
        for (int i = 0; i < this.filters.size(); ++i) {
            bitmaps.add(this.filters.get(i).getBitmapIndex(selector));
        }
        return selector.getBitmapFactory().union(bitmaps);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        return this.makeMatcher(matchers);
    }

    @Override
    public ValueMatcher makeMatcher(BitmapIndexSelector selector, ValueMatcherFactory valueMatcherFactory, RowOffsetMatcherFactory rowOffsetMatcherFactory) {
        final ArrayList<ValueMatcher> matchers = new ArrayList<ValueMatcher>();
        ArrayList<ImmutableBitmap> bitmaps = new ArrayList<ImmutableBitmap>();
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) {
                bitmaps.add(filter.getBitmapIndex(selector));
                continue;
            }
            ValueMatcher matcher = filter.makeMatcher(valueMatcherFactory);
            matchers.add(matcher);
        }
        if (bitmaps.size() > 0) {
            ImmutableBitmap combinedBitmap = selector.getBitmapFactory().union(bitmaps);
            ValueMatcher offsetMatcher = rowOffsetMatcherFactory.makeRowOffsetMatcher(combinedBitmap);
            matchers.add(0, offsetMatcher);
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher valueMatcher : matchers) {
                    if (!valueMatcher.matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (!matcher.matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("(%s)", OR_JOINER.join(this.filters));
    }
}

