/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hive.druid.io.druid.segment.data.CompressedByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;

public class VSizeCompressedObjectStrategy
extends CompressedObjectStrategy<ByteBuffer> {
    private final int expectedBytes;

    public static VSizeCompressedObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int expectedBytes) {
        return new VSizeCompressedObjectStrategy(order, compression, expectedBytes);
    }

    protected VSizeCompressedObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int expectedBytes) {
        super(order, new CompressedObjectStrategy.BufferConverter<ByteBuffer>(){

            @Override
            public ByteBuffer convert(ByteBuffer buf) {
                return buf;
            }

            @Override
            public int compare(ByteBuffer lhs, ByteBuffer rhs) {
                return CompressedByteBufferObjectStrategy.ORDERING.compare(lhs, rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count;
            }

            @Override
            public ByteBuffer combine(ByteBuffer into, ByteBuffer from) {
                return into.put(from);
            }
        }, compression);
        this.expectedBytes = expectedBytes;
    }

    @Override
    protected ByteBuffer bufferFor(ByteBuffer val) {
        return ByteBuffer.allocate(this.expectedBytes).order(this.order);
    }

    @Override
    protected void decompress(ByteBuffer buffer, int numBytes, ByteBuffer buf) {
        this.decompressor.decompress(buffer, numBytes, buf, this.expectedBytes);
    }
}

