/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.VSizeLongSerde;

public class TableLongEncodingReader
implements CompressionFactory.LongEncodingReader {
    private final long[] table;
    private final int bitsPerValue;
    private final ByteBuffer buffer;
    private VSizeLongSerde.LongDeserializer deserializer;

    public TableLongEncodingReader(ByteBuffer fromBuffer) {
        this.buffer = fromBuffer.asReadOnlyBuffer();
        byte version = this.buffer.get();
        if (version == 1) {
            int tableSize = this.buffer.getInt();
            if (tableSize < 0 || tableSize > 256) {
                throw new IAE("Invalid table size[%s]", tableSize);
            }
            this.bitsPerValue = VSizeLongSerde.getBitsForMax(tableSize);
            this.table = new long[tableSize];
            for (int i = 0; i < tableSize; ++i) {
                this.table[i] = this.buffer.getLong();
            }
        } else {
            throw new IAE("Unknown version[%s]", version);
        }
        fromBuffer.position(this.buffer.position());
        this.deserializer = VSizeLongSerde.getDeserializer(this.bitsPerValue, this.buffer, this.buffer.position());
    }

    private TableLongEncodingReader(ByteBuffer buffer, long[] table, int bitsPerValue) {
        this.buffer = buffer;
        this.table = table;
        this.bitsPerValue = bitsPerValue;
        this.deserializer = VSizeLongSerde.getDeserializer(bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.deserializer = VSizeLongSerde.getDeserializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public long read(int index) {
        return this.table[(int)this.deserializer.get(index)];
    }

    @Override
    public int getNumBytes(int values) {
        return VSizeLongSerde.getSerializedSize(this.bitsPerValue, values);
    }

    @Override
    public CompressionFactory.LongEncodingReader duplicate() {
        return new TableLongEncodingReader(this.buffer.duplicate(), this.table, this.bitsPerValue);
    }
}

