/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.metamx.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class ConciseBitmapSerdeFactory
implements BitmapSerdeFactory {
    private static final ObjectStrategy<ImmutableBitmap> objectStrategy = new ImmutableConciseSetObjectStrategy();
    private static final BitmapFactory bitmapFactory = new ConciseBitmapFactory();
    private static Ordering<WrappedImmutableConciseBitmap> conciseComparator = new Ordering<WrappedImmutableConciseBitmap>(){

        @Override
        public int compare(WrappedImmutableConciseBitmap conciseSet, WrappedImmutableConciseBitmap conciseSet1) {
            if (conciseSet.size() == 0 && conciseSet1.size() == 0) {
                return 0;
            }
            if (conciseSet.size() == 0) {
                return -1;
            }
            if (conciseSet1.size() == 0) {
                return 1;
            }
            return conciseSet.compareTo(conciseSet1);
        }
    }.nullsFirst();

    @Override
    public ObjectStrategy<ImmutableBitmap> getObjectStrategy() {
        return objectStrategy;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return bitmapFactory;
    }

    public String toString() {
        return "ConciseBitmapSerdeFactory{}";
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ConciseBitmapSerdeFactory;
    }

    public int hashCode() {
        return 0;
    }

    private static class ImmutableConciseSetObjectStrategy
    implements ObjectStrategy<ImmutableBitmap> {
        private ImmutableConciseSetObjectStrategy() {
        }

        @Override
        public Class<ImmutableBitmap> getClazz() {
            return ImmutableBitmap.class;
        }

        @Override
        public WrappedImmutableConciseBitmap fromByteBuffer(ByteBuffer buffer, int numBytes) {
            ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
            readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
            return new WrappedImmutableConciseBitmap(new ImmutableConciseSet(readOnlyBuffer));
        }

        @Override
        public byte[] toBytes(ImmutableBitmap val) {
            if (val == null || val.size() == 0) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableBitmap o1, ImmutableBitmap o2) {
            return conciseComparator.compare((WrappedImmutableConciseBitmap)o1, (WrappedImmutableConciseBitmap)o2);
        }
    }
}

