/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.IndexedFloats;

public class CompressedFloatsIndexedSupplier
implements Supplier<IndexedFloats> {
    public static final byte LZF_VERSION = 1;
    public static final byte version = 2;
    private final int totalSize;
    private final int sizePer;
    private final ByteBuffer buffer;
    private final Supplier<IndexedFloats> supplier;
    private final CompressedObjectStrategy.CompressionStrategy compression;

    CompressedFloatsIndexedSupplier(int totalSize, int sizePer, ByteBuffer buffer, Supplier<IndexedFloats> supplier, CompressedObjectStrategy.CompressionStrategy compression) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.buffer = buffer;
        this.supplier = supplier;
        this.compression = compression;
    }

    public int size() {
        return this.totalSize;
    }

    @Override
    public IndexedFloats get() {
        return this.supplier.get();
    }

    public long getSerializedSize() {
        return this.buffer.remaining() + 1 + 4 + 4 + 1;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray(this.sizePer)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        channel.write(this.buffer.asReadOnlyBuffer());
    }

    public static CompressedFloatsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.LZF;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                compression = CompressedObjectStrategy.CompressionStrategy.forId(compressionId);
            }
            Supplier<IndexedFloats> supplier = CompressionFactory.getFloatSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, compression);
            return new CompressedFloatsIndexedSupplier(totalSize, sizePer, buffer, supplier, compression);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }
}

