/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.StringDimensionHandler;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedIterable;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexStorageAdapter;

public class StringDimensionIndexer
implements DimensionIndexer<Integer, int[], String> {
    private static final Logger log = new Logger(StringDimensionIndexer.class);
    private DimensionDictionary dimLookup = new DimensionDictionary();
    private SortedDimensionDictionary sortedLookup;

    @Override
    public int[] processRowValsToUnsortedEncodedArray(Object dimValues) {
        int[] encodedDimensionValues;
        int oldDictSize = this.dimLookup.size();
        if (dimValues == null) {
            this.dimLookup.add(null);
            encodedDimensionValues = null;
        } else if (dimValues instanceof List) {
            int i;
            List dimValuesList = (List)dimValues;
            String[] dimensionValues = new String[dimValuesList.size()];
            for (i = 0; i < dimValuesList.size(); ++i) {
                dimensionValues[i] = StringDimensionHandler.STRING_TRANSFORMER.apply(dimValuesList.get(i));
            }
            Arrays.sort(dimensionValues, StringDimensionHandler.UNENCODED_COMPARATOR);
            encodedDimensionValues = new int[dimensionValues.length];
            for (i = 0; i < dimensionValues.length; ++i) {
                encodedDimensionValues[i] = this.dimLookup.add(dimensionValues[i]);
            }
        } else {
            String transformedVal = StringDimensionHandler.STRING_TRANSFORMER.apply(dimValues);
            encodedDimensionValues = new int[]{this.dimLookup.add(transformedVal)};
        }
        if (oldDictSize != this.dimLookup.size()) {
            this.sortedLookup = null;
        }
        return encodedDimensionValues;
    }

    @Override
    public Integer getSortedEncodedValueFromUnsorted(Integer unsortedIntermediateValue) {
        this.updateSortedLookup();
        return this.sortedLookup.getSortedIdFromUnsortedId(unsortedIntermediateValue);
    }

    @Override
    public Integer getUnsortedEncodedValueFromSorted(Integer sortedIntermediateValue) {
        this.updateSortedLookup();
        return this.sortedLookup.getUnsortedIdFromSortedId(sortedIntermediateValue);
    }

    @Override
    public Indexed<String> getSortedIndexedValues() {
        this.updateSortedLookup();
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return StringDimensionIndexer.this.getCardinality();
            }

            @Override
            public String get(int index) {
                return StringDimensionIndexer.this.getActualValue(index, true);
            }

            @Override
            public int indexOf(String value) {
                int id = StringDimensionIndexer.this.getEncodedValue(value, false);
                return id < 0 ? -1 : StringDimensionIndexer.this.getSortedEncodedValueFromUnsorted(id);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }
        };
    }

    @Override
    public String getMinValue() {
        return this.dimLookup.getMinValue();
    }

    @Override
    public String getMaxValue() {
        return this.dimLookup.getMaxValue();
    }

    @Override
    public int getCardinality() {
        return this.dimLookup.size();
    }

    @Override
    public int compareUnsortedEncodedArrays(int[] lhs, int[] rhs) {
        int lhsLen = lhs.length;
        int rhsLen = rhs.length;
        int retVal = Ints.compare(lhsLen, rhsLen);
        for (int valsIndex = 0; retVal == 0 && valsIndex < lhsLen; ++valsIndex) {
            int lhsVal = lhs[valsIndex];
            int rhsVal = rhs[valsIndex];
            if (lhsVal == rhsVal) continue;
            String lhsValActual = this.getActualValue(lhsVal, false);
            String rhsValActual = this.getActualValue(rhsVal, false);
            if (lhsValActual != null && rhsValActual != null) {
                retVal = lhsValActual.compareTo(rhsValActual);
                continue;
            }
            if (!(lhsValActual == null ^ rhsValActual == null)) continue;
            retVal = lhsValActual == null ? -1 : 1;
        }
        return retVal;
    }

    @Override
    public boolean checkUnsortedEncodedArraysEqual(int[] lhs, int[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedArrayHashCode(int[] key) {
        return Arrays.hashCode(key);
    }

    @Override
    public Object makeColumnValueSelector(DimensionSpec spec, final IncrementalIndexStorageAdapter.EntryHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final ExtractionFn extractionFn = spec.getExtractionFn();
        final int dimIndex = desc.getIndex();
        final int maxId = this.getCardinality();
        return new DimensionSelector(){

            @Override
            public IndexedInts getRow() {
                Object[] dims = currEntry.getKey().getDims();
                int[] indices = dimIndex < dims.length ? (int[])dims[dimIndex] : null;
                int nullId = StringDimensionIndexer.this.getEncodedValue(null, false);
                ArrayList<Integer> valsTmp = null;
                if ((indices == null || indices.length == 0) && nullId > -1) {
                    if (nullId < maxId) {
                        valsTmp = new ArrayList<Integer>(1);
                        valsTmp.add(nullId);
                    }
                } else if (indices != null && indices.length > 0) {
                    valsTmp = new ArrayList(indices.length);
                    for (int i = 0; i < indices.length; ++i) {
                        int id = indices[i];
                        if (id >= maxId) continue;
                        valsTmp.add(id);
                    }
                }
                final List<Object> vals = valsTmp == null ? Collections.EMPTY_LIST : valsTmp;
                return new IndexedInts(){

                    @Override
                    public int size() {
                        return vals.size();
                    }

                    @Override
                    public int get(int index) {
                        return (Integer)vals.get(index);
                    }

                    @Override
                    public Iterator<Integer> iterator() {
                        return vals.iterator();
                    }

                    @Override
                    public void fill(int index, int[] toFill) {
                        throw new UnsupportedOperationException("fill not supported");
                    }

                    @Override
                    public void close() throws IOException {
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return maxId;
            }

            @Override
            public String lookupName(int id) {
                String strValue = StringDimensionIndexer.this.getActualValue(id, false);
                return extractionFn == null ? strValue : extractionFn.apply(strValue);
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn != null) {
                    throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                }
                return StringDimensionIndexer.this.getEncodedValue(name, false);
            }
        };
    }

    @Override
    public Object convertUnsortedEncodedArrayToActualArrayOrList(int[] key, boolean asList) {
        if (key == null || key.length == 0) {
            return null;
        }
        if (key.length == 1) {
            String val = this.getActualValue(key[0], false);
            val = Strings.nullToEmpty(val);
            return val;
        }
        if (asList) {
            ArrayList<String> rowVals = new ArrayList<String>(key.length);
            for (int i = 0; i < key.length; ++i) {
                String val = this.getActualValue(key[i], false);
                rowVals.add(Strings.nullToEmpty(val));
            }
            return rowVals;
        }
        String[] rowArray = new String[key.length];
        for (int i = 0; i < key.length; ++i) {
            String val = this.getActualValue(key[i], false);
            rowArray[i] = Strings.nullToEmpty(val);
        }
        return rowArray;
    }

    @Override
    public int[] convertUnsortedEncodedArrayToSortedEncodedArray(int[] key) {
        int[] sortedDimVals = new int[key.length];
        for (int i = 0; i < key.length; ++i) {
            sortedDimVals[i] = this.getSortedEncodedValueFromUnsorted(key[i]);
        }
        return sortedDimVals;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedArray(int[] key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        for (int dimValIdx : key) {
            if (bitmapIndexes[dimValIdx] == null) {
                bitmapIndexes[dimValIdx] = factory.makeEmptyMutableBitmap();
            }
            bitmapIndexes[dimValIdx].add(rowNum);
        }
    }

    @Override
    public ValueMatcher makeIndexingValueMatcher(Comparable matchValue, final IncrementalIndexStorageAdapter.EntryHolder holder, final int dimIndex) {
        String value = StringDimensionHandler.STRING_TRANSFORMER.apply(matchValue);
        final int encodedVal = this.getEncodedValue(value, false);
        final boolean matchOnNull = Strings.isNullOrEmpty(value);
        if (encodedVal < 0 && !matchOnNull) {
            return new BooleanValueMatcher(false);
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                Object[] dims = holder.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return matchOnNull;
                }
                int[] dimsInt = (int[])dims[dimIndex];
                if (dimsInt == null || dimsInt.length == 0) {
                    return matchOnNull;
                }
                for (int i = 0; i < dimsInt.length; ++i) {
                    if (dimsInt[i] != encodedVal) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public ValueMatcher makeIndexingValueMatcher(DruidPredicateFactory predicateFactory, final IncrementalIndexStorageAdapter.EntryHolder holder, final int dimIndex) {
        final Predicate<String> predicate = predicateFactory.makeStringPredicate();
        final boolean matchOnNull = predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                Object[] dims = holder.getKey().getDims();
                if (dimIndex >= dims.length) {
                    return matchOnNull;
                }
                int[] dimsInt = (int[])dims[dimIndex];
                if (dimsInt == null || dimsInt.length == 0) {
                    return matchOnNull;
                }
                for (int i = 0; i < dimsInt.length; ++i) {
                    String finalDimVal = StringDimensionIndexer.this.getActualValue(dimsInt[i], false);
                    if (!predicate.apply(finalDimVal)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private void updateSortedLookup() {
        if (this.sortedLookup == null) {
            this.sortedLookup = this.dimLookup.sort();
        }
    }

    private String getActualValue(int intermediateValue, boolean idSorted) {
        if (idSorted) {
            this.updateSortedLookup();
            return this.sortedLookup.getValueFromSortedId(intermediateValue);
        }
        return this.dimLookup.getValue(intermediateValue);
    }

    private int getEncodedValue(String fullValue, boolean idSorted) {
        int unsortedId = this.dimLookup.getId(fullValue);
        if (idSorted) {
            this.updateSortedLookup();
            return this.sortedLookup.getSortedIdFromUnsortedId(unsortedId);
        }
        return unsortedId;
    }

    private static class SortedDimensionDictionary {
        private final List<String> sortedVals;
        private final int[] idToIndex;
        private final int[] indexToId;

        public SortedDimensionDictionary(List<String> idToValue, int length) {
            TreeMap<String, Integer> sortedMap = Maps.newTreeMap();
            for (int id = 0; id < length; ++id) {
                sortedMap.put(idToValue.get(id), id);
            }
            this.sortedVals = Lists.newArrayList(sortedMap.keySet());
            this.idToIndex = new int[length];
            this.indexToId = new int[length];
            int index = 0;
            for (Integer id : sortedMap.values()) {
                this.idToIndex[id.intValue()] = index;
                this.indexToId[index] = id;
                ++index;
            }
        }

        public int size() {
            return this.sortedVals.size();
        }

        public int getUnsortedIdFromSortedId(int index) {
            return this.indexToId[index];
        }

        public int getSortedIdFromUnsortedId(int id) {
            return this.idToIndex[id];
        }

        public String getValueFromSortedId(int index) {
            return Strings.emptyToNull(this.sortedVals.get(index));
        }
    }

    private static class DimensionDictionary {
        private String minValue = null;
        private String maxValue = null;
        private final Map<String, Integer> valueToId = Maps.newHashMap();
        private final List<String> idToValue = Lists.newArrayList();
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getId(String value) {
            Object object = this.lock;
            synchronized (object) {
                Integer id = this.valueToId.get(Strings.nullToEmpty(value));
                return id == null ? -1 : id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getValue(int id) {
            Object object = this.lock;
            synchronized (object) {
                return Strings.emptyToNull(this.idToValue.get(id));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(String value) {
            Object object = this.lock;
            synchronized (object) {
                return this.valueToId.containsKey(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.valueToId.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int add(String originalValue) {
            String value = Strings.nullToEmpty(originalValue);
            Object object = this.lock;
            synchronized (object) {
                Integer prev = this.valueToId.get(value);
                if (prev != null) {
                    return prev;
                }
                int index = this.size();
                this.valueToId.put(value, index);
                this.idToValue.add(value);
                this.minValue = this.minValue == null || this.minValue.compareTo(value) > 0 ? value : this.minValue;
                this.maxValue = this.maxValue == null || this.maxValue.compareTo(value) < 0 ? value : this.maxValue;
                return index;
            }
        }

        public String getMinValue() {
            return this.minValue;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedDimensionDictionary sort() {
            Object object = this.lock;
            synchronized (object) {
                return new SortedDimensionDictionary(this.idToValue, this.size());
            }
        }
    }
}

