/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.util.Map;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.com.metamx.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.MetricHolder;
import org.apache.hive.druid.io.druid.segment.data.CompressedLongsIndexedSupplier;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexed;
import org.joda.time.Interval;

public class MMappedIndex {
    private static final Logger log = new Logger(MMappedIndex.class);
    final GenericIndexed<String> availableDimensions;
    final GenericIndexed<String> availableMetrics;
    final Interval dataInterval;
    final CompressedLongsIndexedSupplier timestamps;
    final Map<String, MetricHolder> metrics;
    final Map<String, GenericIndexed<String>> dimValueLookups;
    final Map<String, VSizeIndexed> dimColumns;
    final Map<String, GenericIndexed<ImmutableBitmap>> invertedIndexes;
    final Map<String, ImmutableRTree> spatialIndexes;
    final SmooshedFileMapper fileMapper;

    public MMappedIndex(GenericIndexed<String> availableDimensions, GenericIndexed<String> availableMetrics, Interval dataInterval, CompressedLongsIndexedSupplier timestamps, Map<String, MetricHolder> metrics, Map<String, GenericIndexed<String>> dimValueLookups, Map<String, VSizeIndexed> dimColumns, Map<String, GenericIndexed<ImmutableBitmap>> invertedIndexes, Map<String, ImmutableRTree> spatialIndexes, SmooshedFileMapper fileMapper) {
        this.availableDimensions = availableDimensions;
        this.availableMetrics = availableMetrics;
        this.dataInterval = dataInterval;
        this.timestamps = timestamps;
        this.metrics = metrics;
        this.dimValueLookups = dimValueLookups;
        this.dimColumns = dimColumns;
        this.invertedIndexes = invertedIndexes;
        this.spatialIndexes = spatialIndexes;
        this.fileMapper = fileMapper;
    }

    public CompressedLongsIndexedSupplier getTimestamps() {
        return this.timestamps;
    }

    public GenericIndexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    public GenericIndexed<String> getAvailableMetrics() {
        return this.availableMetrics;
    }

    public Map<String, MetricHolder> getMetrics() {
        return this.metrics;
    }

    public Interval getDataInterval() {
        return this.dataInterval;
    }

    public MetricHolder getMetricHolder(String metric) {
        MetricHolder retVal = this.metrics.get(metric);
        if (retVal == null) {
            return null;
        }
        return retVal;
    }

    public GenericIndexed<String> getDimValueLookup(String dimension) {
        return this.dimValueLookups.get(dimension);
    }

    public VSizeIndexed getDimColumn(String dimension) {
        return this.dimColumns.get(dimension);
    }

    public Map<String, GenericIndexed<ImmutableBitmap>> getBitmapIndexes() {
        return this.invertedIndexes;
    }

    public Map<String, ImmutableRTree> getSpatialIndexes() {
        return this.spatialIndexes;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    public void close() throws IOException {
        if (this.fileMapper != null) {
            this.fileMapper.close();
        }
    }
}

