/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.LongSupplierSerializer;

public class LongColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final CompressionFactory.LongEncodingStrategy encoding;
    private LongSupplierSerializer writer;

    public static LongColumnSerializer create(IOPeon ioPeon, String filenameBase, CompressedObjectStrategy.CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding) {
        return new LongColumnSerializer(ioPeon, filenameBase, IndexIO.BYTE_ORDER, compression, encoding);
    }

    public LongColumnSerializer(IOPeon ioPeon, String filenameBase, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.encoding = encoding;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getLongSerializer(this.ioPeon, String.format("%s.long_column", this.filenameBase), this.byteOrder, this.encoding, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        long val = obj == null ? 0L : ((Number)obj).longValue();
        this.writer.add(val);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long getSerializedSize() {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        this.writer.writeToChannel(channel);
    }
}

