/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.Closer;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.com.metamx.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.common.utils.JodaUtils;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionMerger;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.FloatColumnSerializer;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.LongColumnSerializer;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ColumnDescriptor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.TmpFileIOPeon;
import org.apache.hive.druid.io.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexColumnSerializer;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;
import org.apache.hive.druid.io.druid.segment.serde.FloatGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.LongGenericColumnPartSerde;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMergerV9
extends IndexMerger {
    private static final Logger log = new Logger(IndexMergerV9.class);

    @Inject
    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO) {
        super(mapper, indexIO);
    }

    @Override
    protected File makeIndexFiles(List<IndexableAdapter> adapters, AggregatorFactory[] metricAggs, File outDir, ProgressIndicator progress, List<String> mergedDimensions, List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, IndexSpec indexSpec) throws IOException {
        progress.start();
        progress.progress();
        List<Metadata> metadataList = Lists.transform(adapters, new Function<IndexableAdapter, Metadata>(){

            @Override
            public Metadata apply(IndexableAdapter input) {
                return input.getMetadata();
            }
        });
        Metadata segmentMetadata = null;
        if (metricAggs != null) {
            AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[metricAggs.length];
            for (int i = 0; i < metricAggs.length; ++i) {
                combiningMetricAggs[i] = metricAggs[i].getCombiningFactory();
            }
            segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        } else {
            segmentMetadata = Metadata.merge(metadataList, null);
        }
        Closer closer = Closer.create();
        final TmpFileIOPeon ioPeon = new TmpFileIOPeon(false);
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                ioPeon.cleanup();
            }
        });
        FileSmoosher v9Smoosher = new FileSmoosher(outDir);
        final File v9TmpDir = new File(outDir, "v9-tmp");
        v9TmpDir.mkdirs();
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                FileUtils.deleteDirectory((File)v9TmpDir);
            }
        });
        log.info("Start making v9 index files, outDir:%s", outDir);
        try {
            long startTime = System.currentTimeMillis();
            ByteStreams.write(Ints.toByteArray(9), Files.newOutputStreamSupplier(new File(outDir, "version.bin")));
            log.info("Completed version.bin in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            TreeMap<String, ValueType> metricsValueTypes = Maps.newTreeMap(Ordering.natural().nullsFirst());
            TreeMap<String, String> metricTypeNames = Maps.newTreeMap(Ordering.natural().nullsFirst());
            ArrayList<ColumnCapabilitiesImpl> dimCapabilities = Lists.newArrayListWithCapacity(mergedDimensions.size());
            this.mergeCapabilities(adapters, mergedDimensions, metricsValueTypes, metricTypeNames, dimCapabilities);
            DimensionHandler[] handlers = this.makeDimensionHandlers(mergedDimensions, dimCapabilities);
            ArrayList<DimensionMerger> mergers = new ArrayList<DimensionMerger>();
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                mergers.add(handlers[i].makeMerger(indexSpec, v9TmpDir, ioPeon, (ColumnCapabilities)dimCapabilities.get(i), progress));
            }
            progress.progress();
            startTime = System.currentTimeMillis();
            ArrayList dimConversions = Lists.newArrayListWithCapacity(adapters.size());
            ArrayList dimensionSkipFlag = Lists.newArrayListWithCapacity(mergedDimensions.size());
            ArrayList convertMissingDimsFlags = Lists.newArrayListWithCapacity(mergedDimensions.size());
            this.writeDimValueAndSetupDimConversion(adapters, progress, mergedDimensions, mergers);
            log.info("Completed dim conversions in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            Iterable<Rowboat> theRows = this.makeRowIterable(adapters, mergedDimensions, mergedMetrics, rowMergerFn, dimCapabilities, handlers, mergers);
            LongColumnSerializer timeWriter = this.setupTimeWriter(ioPeon, indexSpec);
            ArrayList<GenericColumnSerializer> metWriters = this.setupMetricsWriters(ioPeon, mergedMetrics, metricsValueTypes, metricTypeNames, indexSpec);
            ArrayList<IntBuffer> rowNumConversions = Lists.newArrayListWithCapacity(adapters.size());
            this.mergeIndexesAndWriteColumns(adapters, progress, theRows, timeWriter, metWriters, rowNumConversions, mergers);
            String section = "build inverted index and columns";
            progress.startSection("build inverted index and columns");
            this.makeTimeColumn(v9Smoosher, progress, timeWriter);
            this.makeMetricsColumns(v9Smoosher, progress, mergedMetrics, metricsValueTypes, metricTypeNames, metWriters);
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(i);
                merger.writeIndexes(rowNumConversions, closer);
                if (merger.canSkip()) continue;
                ColumnDescriptor columnDesc = merger.makeColumnDescriptor();
                this.makeColumn(v9Smoosher, mergedDimensions.get(i), columnDesc);
            }
            progress.stopSection("build inverted index and columns");
            progress.progress();
            this.makeIndexBinary(v9Smoosher, adapters, outDir, mergedDimensions, mergedMetrics, progress, indexSpec, mergers);
            this.makeMetadataBinary(v9Smoosher, progress, segmentMetadata);
            v9Smoosher.close();
            progress.stop();
            File file = outDir;
            return file;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private void makeMetadataBinary(FileSmoosher v9Smoosher, ProgressIndicator progress, Metadata segmentMetadata) throws IOException {
        if (segmentMetadata != null) {
            progress.startSection("make metadata.drd");
            v9Smoosher.add("metadata.drd", ByteBuffer.wrap(this.mapper.writeValueAsBytes(segmentMetadata)));
            progress.stopSection("make metadata.drd");
        }
    }

    private void makeIndexBinary(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, File outDir, List<String> mergedDimensions, List<String> mergedMetrics, ProgressIndicator progress, IndexSpec indexSpec, List<DimensionMerger> mergers) throws IOException {
        String section = "make index.drd";
        progress.startSection("make index.drd");
        long startTime = System.currentTimeMillis();
        LinkedHashSet<String> finalDimensions = Sets.newLinkedHashSet();
        LinkedHashSet<String> finalColumns = Sets.newLinkedHashSet();
        finalColumns.addAll(mergedMetrics);
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            if (mergers.get(i).canSkip()) continue;
            finalColumns.add(mergedDimensions.get(i));
            finalDimensions.add(mergedDimensions.get(i));
        }
        GenericIndexed<String> cols = GenericIndexed.fromIterable(finalColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> dims = GenericIndexed.fromIterable(finalDimensions, GenericIndexed.STRING_STRATEGY);
        String bitmapSerdeFactoryType = this.mapper.writeValueAsString(indexSpec.getBitmapSerdeFactory());
        long numBytes = cols.getSerializedSize() + dims.getSerializedSize() + 16L + (long)serializerUtils.getSerializedStringByteSize(bitmapSerdeFactoryType);
        SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);
        cols.writeToChannel(writer);
        dims.writeToChannel(writer);
        DateTime minTime = new DateTime(0x3FFFFFFFFFFFFFFFL);
        DateTime maxTime = new DateTime(-4611686018427387904L);
        for (IndexableAdapter index : adapters) {
            minTime = JodaUtils.minDateTime(minTime, index.getDataInterval().getStart());
            maxTime = JodaUtils.maxDateTime(maxTime, index.getDataInterval().getEnd());
        }
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
        serializerUtils.writeLong(writer, dataInterval.getStartMillis());
        serializerUtils.writeLong(writer, dataInterval.getEndMillis());
        serializerUtils.writeString(writer, bitmapSerdeFactoryType);
        writer.close();
        IndexIO.checkFileSize(new File(outDir, "index.drd"));
        log.info("Completed index.drd in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make index.drd");
    }

    private void makeMetricsColumns(FileSmoosher v9Smoosher, ProgressIndicator progress, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<GenericColumnSerializer> metWriters) throws IOException {
        String section = "make metric columns";
        progress.startSection("make metric columns");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < mergedMetrics.size(); ++i) {
            String metric = mergedMetrics.get(i);
            long metricStartTime = System.currentTimeMillis();
            GenericColumnSerializer writer = metWriters.get(i);
            writer.close();
            ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    builder.setValueType(ValueType.LONG);
                    builder.addSerde(LongGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate((LongColumnSerializer)writer).build());
                    break;
                }
                case FLOAT: {
                    builder.setValueType(ValueType.FLOAT);
                    builder.addSerde(FloatGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate((FloatColumnSerializer)writer).build());
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    builder.setValueType(ValueType.COMPLEX);
                    builder.addSerde(ComplexColumnPartSerde.serializerBuilder().withTypeName(typeName).withDelegate((ComplexColumnSerializer)writer).build());
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            this.makeColumn(v9Smoosher, metric, builder.build());
            log.info("Completed metric column[%s] in %,d millis.", metric, System.currentTimeMillis() - metricStartTime);
        }
        log.info("Completed metric columns in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make metric columns");
    }

    private void makeTimeColumn(FileSmoosher v9Smoosher, ProgressIndicator progress, LongColumnSerializer timeWriter) throws IOException {
        String section = "make time column";
        progress.startSection("make time column");
        long startTime = System.currentTimeMillis();
        timeWriter.close();
        ColumnDescriptor serdeficator = ColumnDescriptor.builder().setValueType(ValueType.LONG).addSerde(LongGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(timeWriter).build()).build();
        this.makeColumn(v9Smoosher, "__time", serdeficator);
        log.info("Completed time column in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make time column");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeColumn(FileSmoosher v9Smoosher, String columnName, ColumnDescriptor serdeficator) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializerUtils.writeString(baos, this.mapper.writeValueAsString(serdeficator));
        byte[] specBytes = baos.toByteArray();
        try (SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(columnName, serdeficator.numBytes() + (long)specBytes.length);){
            channel.write(ByteBuffer.wrap(specBytes));
            serdeficator.write(channel);
        }
    }

    private void mergeIndexesAndWriteColumns(List<IndexableAdapter> adapters, ProgressIndicator progress, Iterable<Rowboat> theRows, LongColumnSerializer timeWriter, ArrayList<GenericColumnSerializer> metWriters, List<IntBuffer> rowNumConversions, List<DimensionMerger> mergers) throws IOException {
        String section = "walk through and merge rows";
        progress.startSection("walk through and merge rows");
        long startTime = System.currentTimeMillis();
        int rowCount = 0;
        for (IndexableAdapter adapter : adapters) {
            int[] arr = new int[adapter.getNumRows()];
            Arrays.fill(arr, -1);
            rowNumConversions.add(IntBuffer.wrap(arr));
        }
        long time = System.currentTimeMillis();
        for (Rowboat theRow : theRows) {
            progress.progress();
            timeWriter.serialize(theRow.getTimestamp());
            Object[] metrics = theRow.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                metWriters.get(i).serialize(metrics[i]);
            }
            Object[] dims = theRow.getDims();
            for (int i = 0; i < dims.length; ++i) {
                DimensionMerger merger = mergers.get(i);
                if (merger.canSkip()) continue;
                merger.processMergedRow(dims[i]);
            }
            for (Map.Entry<Integer, TreeSet<Integer>> comprisedRow : theRow.getComprisedRows().entrySet()) {
                IntBuffer conversionBuffer = rowNumConversions.get(comprisedRow.getKey());
                for (Integer rowNum : comprisedRow.getValue()) {
                    while (conversionBuffer.position() < rowNum) {
                        conversionBuffer.put(-1);
                    }
                    conversionBuffer.put(rowCount);
                }
            }
            if (++rowCount % 500000 != 0) continue;
            log.info("walked 500,000/%d rows in %,d millis.", rowCount, System.currentTimeMillis() - time);
            time = System.currentTimeMillis();
        }
        for (IntBuffer rowNumConversion : rowNumConversions) {
            rowNumConversion.rewind();
        }
        log.info("completed walk through of %,d rows in %,d millis.", rowCount, System.currentTimeMillis() - startTime);
        progress.stopSection("walk through and merge rows");
    }

    private LongColumnSerializer setupTimeWriter(IOPeon ioPeon, IndexSpec indexSpec) throws IOException {
        LongColumnSerializer timeWriter = LongColumnSerializer.create(ioPeon, "little_end_time", CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY, indexSpec.getLongEncoding());
        timeWriter.open();
        return timeWriter;
    }

    private ArrayList<GenericColumnSerializer> setupMetricsWriters(IOPeon ioPeon, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, IndexSpec indexSpec) throws IOException {
        ArrayList<GenericColumnSerializer> metWriters = Lists.newArrayListWithCapacity(mergedMetrics.size());
        CompressedObjectStrategy.CompressionStrategy metCompression = indexSpec.getMetricCompression();
        CompressionFactory.LongEncodingStrategy longEncoding = indexSpec.getLongEncoding();
        for (String metric : mergedMetrics) {
            GenericColumnSerializer writer;
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    writer = LongColumnSerializer.create(ioPeon, metric, metCompression, longEncoding);
                    break;
                }
                case FLOAT: {
                    writer = FloatColumnSerializer.create(ioPeon, metric, metCompression);
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                    if (serde == null) {
                        throw new ISE("Unknown type[%s]", typeName);
                    }
                    writer = ComplexColumnSerializer.create(ioPeon, metric, serde);
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            writer.open();
            metWriters.add(writer);
        }
        return metWriters;
    }

    private void writeDimValueAndSetupDimConversion(List<IndexableAdapter> indexes, ProgressIndicator progress, List<String> mergedDimensions, List<DimensionMerger> mergers) throws IOException {
        String section = "setup dimension conversions";
        progress.startSection("setup dimension conversions");
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            mergers.get(dimIndex).writeMergedValueMetadata(indexes);
        }
        progress.stopSection("setup dimension conversions");
    }

    private void mergeCapabilities(List<IndexableAdapter> adapters, List<String> mergedDimensions, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<ColumnCapabilitiesImpl> dimCapabilities) {
        HashMap<String, ColumnCapabilitiesImpl> capabilitiesMap = Maps.newHashMap();
        for (IndexableAdapter adapter : adapters) {
            ColumnCapabilitiesImpl mergedCapabilities;
            for (String dimension : adapter.getDimensionNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)capabilitiesMap.get(dimension);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                    mergedCapabilities.setType(null);
                }
                capabilitiesMap.put(dimension, mergedCapabilities.merge(adapter.getCapabilities(dimension)));
            }
            for (String metric : adapter.getMetricNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)capabilitiesMap.get(metric);
                ColumnCapabilities capabilities = adapter.getCapabilities(metric);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                capabilitiesMap.put(metric, mergedCapabilities.merge(capabilities));
                metricsValueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        for (String dim : mergedDimensions) {
            dimCapabilities.add((ColumnCapabilitiesImpl)capabilitiesMap.get(dim));
        }
    }
}

