/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.PeekingIterator;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.Closer;
import org.apache.hive.druid.com.google.common.io.FileWriteMode;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.io.OutputSupplier;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.guava.FunctionalIterable;
import org.apache.hive.druid.com.metamx.common.guava.MergeIterable;
import org.apache.hive.druid.com.metamx.common.guava.nary.BinaryFn;
import org.apache.hive.druid.com.metamx.common.io.smoosh.Smoosh;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.collections.CombiningIterable;
import org.apache.hive.druid.io.druid.common.guava.FileOutputSupplier;
import org.apache.hive.druid.io.druid.common.guava.GuavaUtils;
import org.apache.hive.druid.io.druid.common.utils.JodaUtils;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.segment.BaseProgressIndicator;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtil;
import org.apache.hive.druid.io.druid.segment.DimensionMerger;
import org.apache.hive.druid.io.druid.segment.DimensionMergerLegacy;
import org.apache.hive.druid.io.druid.segment.FloatMetricColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.LongMetricColumnSerializer;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.MetricColumnSerializer;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedIterable;
import org.apache.hive.druid.io.druid.segment.data.ListIndexed;
import org.apache.hive.druid.io.druid.segment.data.LongSupplierSerializer;
import org.apache.hive.druid.io.druid.segment.data.TmpFileIOPeon;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricColumnSerializer;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMerger {
    private static final Logger log = new Logger(IndexMerger.class);
    protected static final ListIndexed EMPTY_STR_DIM_VAL = new ListIndexed<String>(Arrays.asList(""), String.class);
    protected static final SerializerUtils serializerUtils = new SerializerUtils();
    protected static final int INVALID_ROW = -1;
    protected static final Splitter SPLITTER = Splitter.on(",");
    protected final ObjectMapper mapper;
    protected final IndexIO indexIO;

    @Inject
    public IndexMerger(ObjectMapper mapper, IndexIO indexIO) {
        this.mapper = Preconditions.checkNotNull(mapper, "null ObjectMapper");
        this.indexIO = Preconditions.checkNotNull(indexIO, "null IndexIO");
    }

    public File persist(IncrementalIndex index, File outDir, IndexSpec indexSpec) throws IOException {
        return this.persist(index, index.getInterval(), outDir, indexSpec);
    }

    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec) throws IOException {
        return this.persist(index, dataInterval, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        long firstTimestamp = index.getMinTime().getMillis();
        long lastTimestamp = index.getMaxTime().getMillis();
        if (!dataInterval.contains(firstTimestamp) || !dataInterval.contains(lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", dataInterval, new DateTime(firstTimestamp), new DateTime(lastTimestamp));
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new ISE("Can only persist to directories, [%s] wasn't a directory", outDir);
        }
        log.info("Starting persist for interval[%s], rows[%,d]", dataInterval, index.size());
        return this.merge(Arrays.asList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), false, index.getMetricAggs(), outDir, indexSpec, progress);
    }

    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return this.mergeQueryableIndex(indexes, rollup, metricAggs, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        ArrayList<IndexableAdapter> indexAdapteres = Lists.newArrayList(Iterables.transform(indexes, new Function<QueryableIndex, IndexableAdapter>(){

            @Override
            public IndexableAdapter apply(QueryableIndex input) {
                return new QueryableIndexIndexableAdapter(input);
            }
        }));
        return this.merge(indexAdapteres, rollup, metricAggs, outDir, indexSpec, progress);
    }

    public File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return this.merge(indexes, rollup, metricAggs, outDir, indexSpec, new BaseProgressIndicator());
    }

    private static List<String> getLexicographicMergedDimensions(List<IndexableAdapter> indexes) {
        return IndexMerger.mergeIndexed(Lists.transform(indexes, new Function<IndexableAdapter, Iterable<String>>(){

            @Override
            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getDimensionNames();
            }
        }));
    }

    private static List<String> getLongestSharedDimOrder(List<IndexableAdapter> indexes) {
        int maxSize = 0;
        Indexed<String> orderingCandidate = null;
        for (IndexableAdapter index : indexes) {
            int iterSize = index.getDimensionNames().size();
            if (iterSize <= maxSize) continue;
            maxSize = iterSize;
            orderingCandidate = index.getDimensionNames();
        }
        if (orderingCandidate == null) {
            return null;
        }
        for (IndexableAdapter index : indexes) {
            Iterator candidateIter = orderingCandidate.iterator();
            for (String matchDim : index.getDimensionNames()) {
                boolean matched = false;
                while (candidateIter.hasNext()) {
                    String nextDim = (String)candidateIter.next();
                    if (!matchDim.equals(nextDim)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return null;
            }
        }
        return ImmutableList.copyOf(orderingCandidate);
    }

    public static List<String> getMergedDimensions(List<IndexableAdapter> indexes) {
        if (indexes.size() == 0) {
            return ImmutableList.of();
        }
        List<String> commonDimOrder = IndexMerger.getLongestSharedDimOrder(indexes);
        if (commonDimOrder == null) {
            log.warn("Indexes have incompatible dimension orders, using lexicographic order.", new Object[0]);
            return IndexMerger.getLexicographicMergedDimensions(indexes);
        }
        return commonDimOrder;
    }

    public File merge(List<IndexableAdapter> indexes, final boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        int i;
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", outDir);
        }
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        List<String> mergedMetrics = Lists.transform(IndexMerger.mergeIndexed(Lists.newArrayList(FunctionalIterable.create(indexes).transform(new Function<IndexableAdapter, Iterable<String>>(){

            @Override
            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getMetricNames();
            }
        }))), new Function<String, String>(){

            @Override
            public String apply(@Nullable String input) {
                return input;
            }
        });
        final AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (i = 0; i < metricAggs.length; ++i) {
            AggregatorFactory metricAgg = metricAggs[i];
            int metricIndex = mergedMetrics.indexOf(metricAgg.getName());
            if (metricIndex <= -1) continue;
            sortedMetricAggs[metricIndex] = metricAgg;
        }
        for (i = 0; i < sortedMetricAggs.length; ++i) {
            if (sortedMetricAggs[i] != null) continue;
            throw new IAE("Indices to merge contained metric[%s], but requested metrics did not", mergedMetrics.get(i));
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", i, sortedMetricAggs[i].getName(), mergedMetrics.get(i));
        }
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            @Override
            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                if (rollup) {
                    return CombiningIterable.create(new MergeIterable(Ordering.natural().nullsFirst(), boats), Ordering.natural().nullsFirst(), new RowboatMergeFunction(sortedMetricAggs));
                }
                return new MergeIterable<Rowboat>(new Ordering<Rowboat>(){

                    @Override
                    public int compare(Rowboat left, Rowboat right) {
                        return Longs.compare(left.getTimestamp(), right.getTimestamp());
                    }
                }.nullsFirst(), boats);
            }
        };
        return this.makeIndexFiles(indexes, sortedMetricAggs, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    public File convert(File inDir, File outDir, IndexSpec indexSpec) throws IOException {
        return this.convert(inDir, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File convert(File inDir, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        try (QueryableIndex index = this.indexIO.loadIndex(inDir);){
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
            File file = this.makeIndexFiles(ImmutableList.of(adapter), null, outDir, progress, Lists.newArrayList(adapter.getDimensionNames()), Lists.newArrayList(adapter.getMetricNames()), new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

                @Override
                @Nullable
                public Iterable<Rowboat> apply(ArrayList<Iterable<Rowboat>> input) {
                    return input.get(0);
                }
            }, indexSpec);
            return file;
        }
    }

    public File append(List<IndexableAdapter> indexes, AggregatorFactory[] aggregators, File outDir, IndexSpec indexSpec) throws IOException {
        return this.append(indexes, aggregators, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File append(List<IndexableAdapter> indexes, AggregatorFactory[] aggregators, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", outDir);
        }
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(Lists.transform(indexes, new Function<IndexableAdapter, Iterable<String>>(){

            @Override
            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return Iterables.transform(input.getMetricNames(), new Function<String, String>(){

                    @Override
                    public String apply(@Nullable String input) {
                        return input;
                    }
                });
            }
        }));
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            @Override
            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                return new MergeIterable<Rowboat>(Ordering.natural().nullsFirst(), boats);
            }
        };
        return this.makeIndexFiles(indexes, aggregators, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    protected File makeIndexFiles(List<IndexableAdapter> indexes, AggregatorFactory[] metricAggs, File outDir, ProgressIndicator progress, List<String> mergedDimensions, List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, IndexSpec indexSpec) throws IOException {
        List<Metadata> metadataList = Lists.transform(indexes, new Function<IndexableAdapter, Metadata>(){

            @Override
            @Nullable
            public Metadata apply(IndexableAdapter input) {
                return input.getMetadata();
            }
        });
        Metadata segmentMetadata = null;
        if (metricAggs != null) {
            AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[metricAggs.length];
            for (int i = 0; i < metricAggs.length; ++i) {
                combiningMetricAggs[i] = metricAggs[i].getCombiningFactory();
            }
            segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        } else {
            segmentMetadata = Metadata.merge(metadataList, null);
        }
        TreeMap<String, ValueType> valueTypes = Maps.newTreeMap(Ordering.natural().nullsFirst());
        TreeMap<String, String> metricTypeNames = Maps.newTreeMap(Ordering.natural().nullsFirst());
        final HashMap<String, ColumnCapabilitiesImpl> columnCapabilities = Maps.newHashMap();
        ArrayList<ColumnCapabilitiesImpl> dimCapabilities = new ArrayList<ColumnCapabilitiesImpl>();
        for (IndexableAdapter adapter : indexes) {
            ColumnCapabilities capabilities;
            ColumnCapabilitiesImpl mergedCapabilities;
            for (String dimension : adapter.getDimensionNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(dimension);
                capabilities = adapter.getCapabilities(dimension);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                columnCapabilities.put(dimension, mergedCapabilities.merge(capabilities));
            }
            for (String metric : adapter.getMetricNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(metric);
                capabilities = adapter.getCapabilities(metric);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                columnCapabilities.put(metric, mergedCapabilities.merge(capabilities));
                valueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        for (String dimension : mergedDimensions) {
            dimCapabilities.add((ColumnCapabilitiesImpl)columnCapabilities.get(dimension));
        }
        Closer closer = Closer.create();
        final File v8OutDir = new File(outDir, "v8-tmp");
        v8OutDir.mkdirs();
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                FileUtils.deleteDirectory((File)v8OutDir);
            }
        });
        final TmpFileIOPeon ioPeon = new TmpFileIOPeon();
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                ioPeon.cleanup();
            }
        });
        try {
            Interval dataInterval;
            progress.progress();
            long startTime = System.currentTimeMillis();
            File indexFile = new File(v8OutDir, "index.drd");
            try (FileOutputStream fileOutputStream = new FileOutputStream(indexFile);
                 FileChannel channel = fileOutputStream.getChannel();){
                channel.write(ByteBuffer.wrap(new byte[]{8}));
                GenericIndexed.fromIterable(mergedDimensions, GenericIndexed.STRING_STRATEGY).writeToChannel(channel);
                GenericIndexed.fromIterable(mergedMetrics, GenericIndexed.STRING_STRATEGY).writeToChannel(channel);
                DateTime minTime = new DateTime(0x3FFFFFFFFFFFFFFFL);
                DateTime maxTime = new DateTime(-4611686018427387904L);
                for (IndexableAdapter index : indexes) {
                    minTime = JodaUtils.minDateTime(minTime, index.getDataInterval().getStart());
                    maxTime = JodaUtils.maxDateTime(maxTime, index.getDataInterval().getEnd());
                }
                dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
                serializerUtils.writeString(channel, String.format("%s/%s", minTime, maxTime));
                serializerUtils.writeString(channel, this.mapper.writeValueAsString(indexSpec.getBitmapSerdeFactory()));
            }
            IndexIO.checkFileSize(indexFile);
            log.info("outDir[%s] completed index.drd in %,d millis.", v8OutDir, System.currentTimeMillis() - startTime);
            progress.progress();
            startTime = System.currentTimeMillis();
            ArrayList<FileOutputSupplier> dimOuts = Lists.newArrayListWithCapacity(mergedDimensions.size());
            DimensionHandler[] handlers = this.makeDimensionHandlers(mergedDimensions, dimCapabilities);
            ArrayList<DimensionMerger> mergers = new ArrayList<DimensionMerger>();
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionMergerLegacy merger = handlers[i].makeLegacyMerger(indexSpec, v8OutDir, ioPeon, (ColumnCapabilities)dimCapabilities.get(i), progress);
                mergers.add(merger);
                merger.writeMergedValueMetadata(indexes);
                FileOutputSupplier dimOut = new FileOutputSupplier(IndexIO.makeDimFile(v8OutDir, mergedDimensions.get(i)), true);
                merger.writeValueMetadataToFile(dimOut);
                dimOuts.add(dimOut);
            }
            log.info("outDir[%s] completed dim conversions in %,d millis.", v8OutDir, System.currentTimeMillis() - startTime);
            progress.progress();
            startTime = System.currentTimeMillis();
            Iterable<Rowboat> theRows = this.makeRowIterable(indexes, mergedDimensions, mergedMetrics, rowMergerFn, dimCapabilities, handlers, mergers);
            LongSupplierSerializer timeWriter = CompressionFactory.getLongSerializer(ioPeon, "little_end_time", IndexIO.BYTE_ORDER, indexSpec.getLongEncoding(), CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY);
            timeWriter.open();
            ArrayList<MetricColumnSerializer> metWriters = Lists.newArrayListWithCapacity(mergedMetrics.size());
            CompressedObjectStrategy.CompressionStrategy metCompression = indexSpec.getMetricCompression();
            CompressionFactory.LongEncodingStrategy longEncoding = indexSpec.getLongEncoding();
            block35: for (String metric : mergedMetrics) {
                ValueType type = (ValueType)((Object)valueTypes.get(metric));
                switch (type) {
                    case LONG: {
                        metWriters.add(new LongMetricColumnSerializer(metric, v8OutDir, ioPeon, metCompression, longEncoding));
                        continue block35;
                    }
                    case FLOAT: {
                        metWriters.add(new FloatMetricColumnSerializer(metric, v8OutDir, ioPeon, metCompression));
                        continue block35;
                    }
                    case COMPLEX: {
                        String typeName = (String)metricTypeNames.get(metric);
                        Iterator<Rowboat> serde = ComplexMetrics.getSerdeForType(typeName);
                        if (serde == null) {
                            throw new ISE("Unknown type[%s]", typeName);
                        }
                        metWriters.add(new ComplexMetricColumnSerializer(metric, v8OutDir, ioPeon, (ComplexMetricSerde)((Object)serde)));
                        continue block35;
                    }
                }
                throw new ISE("Unknown type[%s]", new Object[]{type});
            }
            for (MetricColumnSerializer metWriter : metWriters) {
                metWriter.open();
            }
            int rowCount = 0;
            long time = System.currentTimeMillis();
            ArrayList<IntBuffer> rowNumConversions = Lists.newArrayListWithCapacity(indexes.size());
            for (IndexableAdapter index : indexes) {
                int[] arr = new int[index.getNumRows()];
                Arrays.fill(arr, -1);
                rowNumConversions.add(IntBuffer.wrap(arr));
            }
            for (Rowboat theRow : theRows) {
                progress.progress();
                timeWriter.add(theRow.getTimestamp());
                Object[] metrics = theRow.getMetrics();
                for (int i = 0; i < metrics.length; ++i) {
                    ((MetricColumnSerializer)metWriters.get(i)).serialize(metrics[i]);
                }
                Object[] dims = theRow.getDims();
                for (int i = 0; i < dims.length; ++i) {
                    ((DimensionMerger)mergers.get(i)).processMergedRow(dims[i]);
                }
                for (Map.Entry<Integer, TreeSet<Integer>> comprisedRow : theRow.getComprisedRows().entrySet()) {
                    IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(comprisedRow.getKey());
                    for (Integer n : comprisedRow.getValue()) {
                        while (conversionBuffer.position() < n) {
                            conversionBuffer.put(-1);
                        }
                        conversionBuffer.put(rowCount);
                    }
                }
                if (++rowCount % 500000 != 0) continue;
                log.info("outDir[%s] walked 500,000/%,d rows in %,d millis.", v8OutDir, rowCount, System.currentTimeMillis() - time);
                time = System.currentTimeMillis();
            }
            for (IntBuffer rowNumConversion : rowNumConversions) {
                rowNumConversion.rewind();
            }
            File timeFile = IndexIO.makeTimeFile(v8OutDir, IndexIO.BYTE_ORDER);
            timeFile.delete();
            ByteSink out = Files.asByteSink(timeFile, FileWriteMode.APPEND);
            timeWriter.closeAndConsolidate(out);
            IndexIO.checkFileSize(timeFile);
            for (MetricColumnSerializer metWriter : metWriters) {
                metWriter.close();
            }
            log.info("outDir[%s] completed walk through of %,d rows in %,d millis.", v8OutDir, rowCount, System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
            File invertedFile = new File(v8OutDir, "inverted.drd");
            Files.touch(invertedFile);
            out = Files.asByteSink(invertedFile, FileWriteMode.APPEND);
            File geoFile = new File(v8OutDir, "spatial.drd");
            Files.touch(geoFile);
            OutputSupplier<FileOutputStream> spatialOut = Files.newOutputStreamSupplier(geoFile, true);
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionMergerLegacy legacyMerger = (DimensionMergerLegacy)mergers.get(i);
                legacyMerger.writeIndexes(rowNumConversions, closer);
                legacyMerger.writeIndexesToFiles(out, spatialOut);
                legacyMerger.writeRowValuesToFile((FileOutputSupplier)dimOuts.get(i));
            }
            log.info("outDir[%s] completed inverted.drd and wrote dimensions in %,d millis.", v8OutDir, System.currentTimeMillis() - startTime);
            Function<String, String> dimFilenameFunction = new Function<String, String>(){

                @Override
                public String apply(@Nullable String input) {
                    String formatString = ((ColumnCapabilitiesImpl)columnCapabilities.get(input)).isDictionaryEncoded() ? "dim_%s.drd" : String.format("numeric_dim_%%s_%s.drd", IndexIO.BYTE_ORDER);
                    return GuavaUtils.formatFunction(formatString).apply(input);
                }
            };
            ArrayList<String> expectedFiles = Lists.newArrayList(Iterables.concat(Arrays.asList("index.drd", "inverted.drd", "spatial.drd", String.format("time_%s.drd", IndexIO.BYTE_ORDER)), Iterables.transform(mergedDimensions, dimFilenameFunction), Iterables.transform(mergedMetrics, GuavaUtils.formatFunction(String.format("met_%%s_%s.drd", IndexIO.BYTE_ORDER)))));
            if (segmentMetadata != null) {
                this.writeMetadataToFile(new File(v8OutDir, "metadata.drd"), segmentMetadata);
                log.info("wrote metadata.drd in outDir[%s].", v8OutDir);
                expectedFiles.add("metadata.drd");
            }
            LinkedHashMap<String, File> files = Maps.newLinkedHashMap();
            for (String string : expectedFiles) {
                files.put(string, new File(v8OutDir, string));
            }
            File file = new File(v8OutDir, "smoosher");
            file.mkdir();
            for (Map.Entry<String, File> entry : Smoosh.smoosh(v8OutDir, file, files).entrySet()) {
                entry.getValue().delete();
            }
            for (File file2 : file.listFiles()) {
                Files.move(file2, new File(v8OutDir, file2.getName()));
            }
            if (!file.delete()) {
                log.info("Unable to delete temporary dir[%s], contains[%s]", file, Arrays.asList(file.listFiles()));
                throw new IOException(String.format("Unable to delete temporary dir[%s]", file));
            }
            this.createIndexDrdFile((byte)8, v8OutDir, GenericIndexed.fromIterable(mergedDimensions, GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable(mergedMetrics, GenericIndexed.STRING_STRATEGY), dataInterval, indexSpec.getBitmapSerdeFactory());
            this.indexIO.getDefaultIndexIOHandler().convertV8toV9(v8OutDir, outDir, indexSpec);
            File file3 = outDir;
            return file3;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    protected DimensionHandler[] makeDimensionHandlers(List<String> mergedDimensions, List<ColumnCapabilitiesImpl> dimCapabilities) {
        DimensionHandler[] handlers = new DimensionHandler[mergedDimensions.size()];
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            ColumnCapabilities capabilities = dimCapabilities.get(i);
            String dimName = mergedDimensions.get(i);
            handlers[i] = DimensionHandlerUtil.getHandlerFromCapabilities(dimName, capabilities);
        }
        return handlers;
    }

    protected Iterable<Rowboat> makeRowIterable(List<IndexableAdapter> indexes, final List<String> mergedDimensions, final List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, List<ColumnCapabilitiesImpl> dimCapabilities, final DimensionHandler[] handlers, List<DimensionMerger> mergers) {
        ArrayList<MMappedIndexRowIterable> boats = Lists.newArrayListWithCapacity(indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            IndexableAdapter adapter = indexes.get(i);
            final int[] dimLookup = this.getColumnIndexReorderingMap(adapter.getDimensionNames(), mergedDimensions);
            final int[] metricLookup = this.getColumnIndexReorderingMap(adapter.getMetricNames(), mergedMetrics);
            Iterable<Rowboat> target = indexes.get(i).getRows();
            if (dimLookup != null || metricLookup != null) {
                target = Iterables.transform(target, new Function<Rowboat, Rowboat>(){

                    @Override
                    public Rowboat apply(Rowboat input) {
                        int n;
                        Object[] newDims;
                        if (dimLookup != null) {
                            newDims = new Object[mergedDimensions.size()];
                            int j = 0;
                            Object[] objectArray = input.getDims();
                            int n2 = objectArray.length;
                            for (n = 0; n < n2; ++n) {
                                Object dim;
                                newDims[dimLookup[j]] = dim = objectArray[n];
                                ++j;
                            }
                        } else {
                            newDims = input.getDims();
                        }
                        Object[] newMetrics = input.getMetrics();
                        if (metricLookup != null) {
                            newMetrics = new Object[mergedMetrics.size()];
                            int j = 0;
                            Object[] objectArray = input.getMetrics();
                            n = objectArray.length;
                            for (int i = 0; i < n; ++i) {
                                Object met;
                                newMetrics[metricLookup[j]] = met = objectArray[i];
                                ++j;
                            }
                        }
                        return new Rowboat(input.getTimestamp(), newDims, newMetrics, input.getRowNum(), handlers);
                    }
                });
            }
            boats.add(new MMappedIndexRowIterable(target, mergedDimensions, i, dimCapabilities, mergers));
        }
        return rowMergerFn.apply(boats);
    }

    private int[] getColumnIndexReorderingMap(Indexed<String> adapterColumnNames, List<String> mergedColumnNames) {
        if (this.isSame(adapterColumnNames, mergedColumnNames)) {
            return null;
        }
        int[] dimLookup = new int[mergedColumnNames.size()];
        for (int i = 0; i < adapterColumnNames.size(); ++i) {
            dimLookup[i] = mergedColumnNames.indexOf(adapterColumnNames.get(i));
        }
        return dimLookup;
    }

    private boolean isSame(Indexed<String> indexed, List<String> values) {
        if (indexed.size() != values.size()) {
            return false;
        }
        for (int i = 0; i < indexed.size(); ++i) {
            if (indexed.get(i).equals(values.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable> ArrayList<T> mergeIndexed(List<Iterable<T>> indexedLists) {
        TreeSet retVal = Sets.newTreeSet(Ordering.natural().nullsFirst());
        for (Iterable<T> indexedList : indexedLists) {
            for (Comparable val : indexedList) {
                retVal.add(val);
            }
        }
        return Lists.newArrayList(retVal);
    }

    public void createIndexDrdFile(byte versionId, File inDir, GenericIndexed<String> availableDimensions, GenericIndexed<String> availableMetrics, Interval dataInterval, BitmapSerdeFactory bitmapSerdeFactory) throws IOException {
        File indexFile = new File(inDir, "index.drd");
        try (FileChannel channel = new FileOutputStream(indexFile).getChannel();){
            channel.write(ByteBuffer.wrap(new byte[]{versionId}));
            availableDimensions.writeToChannel(channel);
            availableMetrics.writeToChannel(channel);
            serializerUtils.writeString(channel, String.format("%s/%s", dataInterval.getStart(), dataInterval.getEnd()));
            serializerUtils.writeString(channel, this.mapper.writeValueAsString(bitmapSerdeFactory));
        }
        IndexIO.checkFileSize(indexFile);
    }

    public static boolean isNullColumn(Iterable<String> dimValues) {
        if (dimValues == null) {
            return true;
        }
        for (String val : dimValues) {
            if (val == null) continue;
            return false;
        }
        return true;
    }

    private void writeMetadataToFile(File metadataFile, Metadata metadata) throws IOException {
        try (FileOutputStream metadataFileOutputStream = new FileOutputStream(metadataFile);
             FileChannel metadataFilechannel = metadataFileOutputStream.getChannel();){
            byte[] metadataBytes = this.mapper.writeValueAsBytes(metadata);
            if (metadataBytes.length != metadataFilechannel.write(ByteBuffer.wrap(metadataBytes))) {
                throw new IOException("Failed to write metadata for file");
            }
        }
        IndexIO.checkFileSize(metadataFile);
    }

    static class DictionaryMergeIterator
    implements Iterator<String> {
        protected final IntBuffer[] conversions;
        protected final PriorityQueue<Pair<Integer, PeekingIterator<String>>> pQueue;
        protected int counter;

        DictionaryMergeIterator(Indexed<String>[] dimValueLookups, boolean useDirect) {
            this.pQueue = new PriorityQueue<Pair<Integer, PeekingIterator<String>>>(dimValueLookups.length, new Comparator<Pair<Integer, PeekingIterator<String>>>(){

                @Override
                public int compare(Pair<Integer, PeekingIterator<String>> lhs, Pair<Integer, PeekingIterator<String>> rhs) {
                    return ((String)((PeekingIterator)lhs.rhs).peek()).compareTo((String)((PeekingIterator)rhs.rhs).peek());
                }
            });
            this.conversions = new IntBuffer[dimValueLookups.length];
            for (int i = 0; i < this.conversions.length; ++i) {
                if (dimValueLookups[i] == null) continue;
                Indexed<String> indexed = dimValueLookups[i];
                this.conversions[i] = useDirect ? ByteBuffer.allocateDirect(indexed.size() * 4).asIntBuffer() : IntBuffer.allocate(indexed.size());
                PeekingIterator<String> iter = Iterators.peekingIterator(Iterators.transform(indexed.iterator(), new Function<String, String>(){

                    @Override
                    public String apply(@Nullable String input) {
                        return Strings.nullToEmpty(input);
                    }
                }));
                if (!iter.hasNext()) continue;
                this.pQueue.add(Pair.of(i, iter));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.pQueue.isEmpty();
        }

        @Override
        public String next() {
            Pair smallest = (Pair)this.pQueue.remove();
            if (smallest == null) {
                throw new NoSuchElementException();
            }
            String value = this.writeTranslate(smallest, this.counter);
            while (!this.pQueue.isEmpty() && value.equals(((PeekingIterator)this.pQueue.peek().rhs).peek())) {
                this.writeTranslate((Pair)this.pQueue.remove(), this.counter);
            }
            ++this.counter;
            return value;
        }

        boolean needConversion(int index) {
            IntBuffer readOnly = this.conversions[index].asReadOnlyBuffer();
            readOnly.rewind();
            int i = 0;
            while (readOnly.hasRemaining()) {
                if (i != readOnly.get()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private String writeTranslate(Pair<Integer, PeekingIterator<String>> smallest, int counter) {
            int index = (Integer)smallest.lhs;
            String value = (String)((PeekingIterator)smallest.rhs).next();
            this.conversions[index].put(counter);
            if (((PeekingIterator)smallest.rhs).hasNext()) {
                this.pQueue.add(smallest);
            }
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class RowboatMergeFunction
    implements BinaryFn<Rowboat, Rowboat, Rowboat> {
        private final AggregatorFactory[] metricAggs;

        public RowboatMergeFunction(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        @Override
        public Rowboat apply(Rowboat lhs, Rowboat rhs) {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
            Object[] metrics = new Object[this.metricAggs.length];
            Object[] lhsMetrics = lhs.getMetrics();
            Object[] rhsMetrics = rhs.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                Object lhsMetric = lhsMetrics[i];
                Object rhsMetric = rhsMetrics[i];
                metrics[i] = lhsMetric == null ? rhsMetric : (rhsMetric == null ? lhsMetric : this.metricAggs[i].combine(lhsMetric, rhsMetric));
            }
            Rowboat retVal = new Rowboat(lhs.getTimestamp(), lhs.getDims(), metrics, lhs.getRowNum(), lhs.getHandlers());
            for (Rowboat rowboat : Arrays.asList(lhs, rhs)) {
                for (Map.Entry<Integer, TreeSet<Integer>> entry : rowboat.getComprisedRows().entrySet()) {
                    for (Integer rowNum : entry.getValue()) {
                        retVal.addRow(entry.getKey(), rowNum);
                    }
                }
            }
            return retVal;
        }
    }

    public static class AggFactoryStringIndexed
    implements Indexed<String> {
        private final AggregatorFactory[] metricAggs;

        public AggFactoryStringIndexed(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public int size() {
            return this.metricAggs.length;
        }

        @Override
        public String get(int index) {
            return this.metricAggs[index].getName();
        }

        @Override
        public int indexOf(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return IndexedIterable.create(this).iterator();
        }
    }

    public static class MMappedIndexRowIterable
    implements Iterable<Rowboat> {
        private final Iterable<Rowboat> index;
        private final List<String> convertedDims;
        private final int indexNumber;
        private final List<ColumnCapabilitiesImpl> dimCapabilities;
        private final List<DimensionMerger> mergers;

        MMappedIndexRowIterable(Iterable<Rowboat> index, List<String> convertedDims, int indexNumber, List<ColumnCapabilitiesImpl> dimCapabilities, List<DimensionMerger> mergers) {
            this.index = index;
            this.convertedDims = convertedDims;
            this.indexNumber = indexNumber;
            this.dimCapabilities = dimCapabilities;
            this.mergers = mergers;
        }

        public Iterable<Rowboat> getIndex() {
            return this.index;
        }

        @Override
        public Iterator<Rowboat> iterator() {
            return Iterators.transform(this.index.iterator(), new Function<Rowboat, Rowboat>(){

                @Override
                public Rowboat apply(@Nullable Rowboat input) {
                    Object[] dims = input.getDims();
                    Object[] newDims = new Object[MMappedIndexRowIterable.this.convertedDims.size()];
                    for (int i = 0; i < MMappedIndexRowIterable.this.convertedDims.size(); ++i) {
                        if (i >= dims.length) continue;
                        newDims[i] = ((DimensionMerger)MMappedIndexRowIterable.this.mergers.get(i)).convertSegmentRowValuesToMergedRowValues(dims[i], MMappedIndexRowIterable.this.indexNumber);
                    }
                    Rowboat retVal = new Rowboat(input.getTimestamp(), newDims, input.getMetrics(), input.getRowNum(), input.getHandlers());
                    retVal.addRow(MMappedIndexRowIterable.this.indexNumber, input.getRowNum());
                    return retVal;
                }
            });
        }
    }

    static class IndexSeekerWithConversion
    implements IndexSeeker {
        private final IntBuffer dimConversions;
        private int currIndex;
        private int currVal;
        private int lastVal;

        IndexSeekerWithConversion(IntBuffer dimConversions) {
            this.dimConversions = dimConversions;
            this.currIndex = 0;
            this.currVal = -1;
            this.lastVal = -1;
        }

        @Override
        public int seek(int dictId) {
            if (this.dimConversions == null) {
                return -1;
            }
            if (this.lastVal != -1) {
                if (dictId <= this.lastVal) {
                    throw new ISE("Value dictId[%d] is less than the last value dictId[%d] I have, cannot be.", dictId, this.lastVal);
                }
                return -1;
            }
            if (this.currVal == -1) {
                this.currVal = this.dimConversions.get();
            }
            if (this.currVal == dictId) {
                int ret = this.currIndex++;
                if (this.dimConversions.hasRemaining()) {
                    this.currVal = this.dimConversions.get();
                } else {
                    this.lastVal = dictId;
                }
                return ret;
            }
            if (this.currVal < dictId) {
                throw new ISE("Skipped currValue dictId[%d], currIndex[%d]; incoming value dictId[%d]", this.currVal, this.currIndex, dictId);
            }
            return -1;
        }
    }

    static interface IndexSeeker {
        public static final int NOT_EXIST = -1;
        public static final int NOT_INIT = -1;

        public int seek(int var1);
    }
}

