/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.topn.DimValHolder;
import org.apache.hive.druid.io.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;

public class TopNNumericResultBuilder
implements TopNResultBuilder {
    private final DateTime timestamp;
    private final DimensionSpec dimSpec;
    private final String metricName;
    private final List<PostAggregator> postAggs;
    private final PriorityQueue<DimValHolder> pQueue;
    private final Comparator<DimValHolder> dimValComparator;
    private final String[] aggFactoryNames;
    private static final Comparator<String> dimNameComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int retval = null == o1 ? (null == o2 ? 0 : -1) : (null == o2 ? 1 : o1.compareTo(o2));
            return retval;
        }
    };
    private final int threshold;
    private final Comparator metricComparator;
    private static final int LOOP_UNROLL_COUNT = 8;

    public TopNNumericResultBuilder(DateTime timestamp, DimensionSpec dimSpec, String metricName, int threshold, Comparator comparator, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        this.timestamp = timestamp;
        this.dimSpec = dimSpec;
        this.metricName = metricName;
        this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(aggFactories);
        this.postAggs = AggregatorUtil.pruneDependentPostAgg(postAggs, this.metricName);
        this.threshold = threshold;
        this.metricComparator = comparator;
        this.dimValComparator = new Comparator<DimValHolder>(){

            @Override
            public int compare(DimValHolder d1, DimValHolder d2) {
                int retVal = TopNNumericResultBuilder.this.metricComparator.compare(d1.getTopNMetricVal(), d2.getTopNMetricVal());
                if (retVal == 0) {
                    retVal = dimNameComparator.compare(d1.getDimName(), d2.getDimName());
                }
                return retVal;
            }
        };
        this.pQueue = new PriorityQueue<DimValHolder>(this.threshold + 1, this.dimValComparator);
    }

    @Override
    public TopNNumericResultBuilder addEntry(String dimName, Object dimValIndex, Object[] metricVals) {
        Preconditions.checkArgument(metricVals.length == this.aggFactoryNames.length, "metricVals must be the same length as aggFactories");
        HashMap<String, Object> metricValues = Maps.newHashMapWithExpectedSize(metricVals.length + this.postAggs.size() + 1);
        metricValues.put(this.dimSpec.getOutputName(), dimName);
        int extra = metricVals.length % 8;
        switch (extra) {
            case 7: {
                metricValues.put(this.aggFactoryNames[6], metricVals[6]);
            }
            case 6: {
                metricValues.put(this.aggFactoryNames[5], metricVals[5]);
            }
            case 5: {
                metricValues.put(this.aggFactoryNames[4], metricVals[4]);
            }
            case 4: {
                metricValues.put(this.aggFactoryNames[3], metricVals[3]);
            }
            case 3: {
                metricValues.put(this.aggFactoryNames[2], metricVals[2]);
            }
            case 2: {
                metricValues.put(this.aggFactoryNames[1], metricVals[1]);
            }
            case 1: {
                metricValues.put(this.aggFactoryNames[0], metricVals[0]);
            }
        }
        for (int i = extra; i < metricVals.length; i += 8) {
            metricValues.put(this.aggFactoryNames[i + 0], metricVals[i + 0]);
            metricValues.put(this.aggFactoryNames[i + 1], metricVals[i + 1]);
            metricValues.put(this.aggFactoryNames[i + 2], metricVals[i + 2]);
            metricValues.put(this.aggFactoryNames[i + 3], metricVals[i + 3]);
            metricValues.put(this.aggFactoryNames[i + 4], metricVals[i + 4]);
            metricValues.put(this.aggFactoryNames[i + 5], metricVals[i + 5]);
            metricValues.put(this.aggFactoryNames[i + 6], metricVals[i + 6]);
            metricValues.put(this.aggFactoryNames[i + 7], metricVals[i + 7]);
        }
        for (PostAggregator postAgg : this.postAggs) {
            metricValues.put(postAgg.getName(), postAgg.compute(metricValues));
        }
        Object topNMetricVal = metricValues.get(this.metricName);
        if (this.shouldAdd(topNMetricVal)) {
            DimValHolder dimValHolder = new DimValHolder.Builder().withTopNMetricVal(topNMetricVal).withDimName(dimName).withDimValIndex(dimValIndex).withMetricValues(metricValues).build();
            this.pQueue.add(dimValHolder);
        }
        if (this.pQueue.size() > this.threshold) {
            this.pQueue.poll();
        }
        return this;
    }

    private boolean shouldAdd(Object topNMetricVal) {
        boolean belowThreshold = this.pQueue.size() < this.threshold;
        boolean belowMax = belowThreshold || this.metricComparator.compare(this.pQueue.peek().getTopNMetricVal(), topNMetricVal) < 0;
        return belowMax;
    }

    @Override
    public TopNResultBuilder addEntry(DimensionAndMetricValueExtractor dimensionAndMetricValueExtractor) {
        Object dimValue = dimensionAndMetricValueExtractor.getDimensionValue(this.metricName);
        if (this.shouldAdd(dimValue)) {
            DimValHolder valHolder = new DimValHolder.Builder().withTopNMetricVal(dimValue).withDimName(dimensionAndMetricValueExtractor.getStringDimensionValue(this.dimSpec.getOutputName())).withMetricValues(dimensionAndMetricValueExtractor.getBaseObject()).build();
            this.pQueue.add(valHolder);
        }
        if (this.pQueue.size() > this.threshold) {
            this.pQueue.poll();
        }
        return this;
    }

    @Override
    public Iterator<DimValHolder> getTopNIterator() {
        return this.pQueue.iterator();
    }

    @Override
    public Result<TopNResultValue> build() {
        DimValHolder[] holderValueArray = this.pQueue.toArray(new DimValHolder[0]);
        Arrays.sort(holderValueArray, new Comparator<DimValHolder>(){

            @Override
            public int compare(DimValHolder d1, DimValHolder d2) {
                int retVal = TopNNumericResultBuilder.this.metricComparator.compare(d2.getTopNMetricVal(), d1.getTopNMetricVal());
                if (retVal == 0) {
                    retVal = dimNameComparator.compare(d1.getDimName(), d2.getDimName());
                }
                return retVal;
            }
        });
        List<DimValHolder> holderValues = Arrays.asList(holderValueArray);
        List<Map<String, Object>> values = Lists.transform(holderValues, new Function<DimValHolder, Map<String, Object>>(){

            @Override
            public Map<String, Object> apply(DimValHolder valHolder) {
                return valHolder.getMetricValues();
            }
        });
        return new Result<TopNResultValue>(this.timestamp, new TopNResultValue(values));
    }
}

