/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.spec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.spec.SpecificSegmentSpec;
import org.apache.hive.druid.io.druid.segment.SegmentMissingException;

public class SpecificSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> base;
    private final SpecificSegmentSpec specificSpec;

    public SpecificSegmentQueryRunner(QueryRunner<T> base, SpecificSegmentSpec specificSpec) {
        this.base = base;
        this.specificSpec = specificSpec;
    }

    @Override
    public Sequence<T> run(Query<T> input, final Map<String, Object> responseContext) {
        final Query<T> query = input.withQuerySegmentSpec(this.specificSpec);
        final Thread currThread = Thread.currentThread();
        final String currThreadName = currThread.getName();
        final String newName = String.format("%s_%s_%s", query.getType(), query.getDataSource(), query.getIntervals());
        final Sequence baseSequence = (Sequence)this.doNamed(currThread, currThreadName, newName, new Callable<Sequence<T>>(){

            @Override
            public Sequence<T> call() throws Exception {
                return SpecificSegmentQueryRunner.this.base.run(query, responseContext);
            }
        });
        return new Sequence<T>(){

            @Override
            public <OutType> OutType accumulate(final OutType initValue, final Accumulator<OutType, T> accumulator) {
                return (OutType)this.doItNamed(new Callable<OutType>(){

                    @Override
                    public OutType call() throws Exception {
                        try {
                            return baseSequence.accumulate(initValue, accumulator);
                        }
                        catch (SegmentMissingException e) {
                            ArrayList<SegmentDescriptor> missingSegments = (ArrayList<SegmentDescriptor>)responseContext.get(Result.MISSING_SEGMENTS_KEY);
                            if (missingSegments == null) {
                                missingSegments = Lists.newArrayList();
                                responseContext.put(Result.MISSING_SEGMENTS_KEY, missingSegments);
                            }
                            missingSegments.add(SpecificSegmentQueryRunner.this.specificSpec.getDescriptor());
                            return initValue;
                        }
                    }
                });
            }

            @Override
            public <OutType> Yielder<OutType> toYielder(final OutType initValue, final YieldingAccumulator<OutType, T> accumulator) {
                return (Yielder)this.doItNamed(new Callable<Yielder<OutType>>(){

                    @Override
                    public Yielder<OutType> call() throws Exception {
                        return this.makeYielder(baseSequence.toYielder(initValue, accumulator));
                    }
                });
            }

            private <OutType> Yielder<OutType> makeYielder(final Yielder<OutType> yielder) {
                return new Yielder<OutType>(){

                    @Override
                    public OutType get() {
                        return yielder.get();
                    }

                    @Override
                    public Yielder<OutType> next(final OutType initValue) {
                        return (Yielder)this.doItNamed(new Callable<Yielder<OutType>>(){

                            @Override
                            public Yielder<OutType> call() throws Exception {
                                return yielder.next(initValue);
                            }
                        });
                    }

                    @Override
                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    @Override
                    public void close() throws IOException {
                        yielder.close();
                    }
                };
            }

            private <RetType> RetType doItNamed(Callable<RetType> toRun) {
                return (RetType)SpecificSegmentQueryRunner.this.doNamed(currThread, currThreadName, newName, toRun);
            }
        };
    }

    private <RetType> RetType doNamed(Thread currThread, String currName, String newName, Callable<RetType> toRun) {
        try {
            currThread.setName(newName);
            RetType RetType = toRun.call();
            return RetType;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        finally {
            currThread.setName(currName);
        }
    }
}

