/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryEngine;
import org.apache.hive.druid.io.druid.query.select.SelectQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.segment.Segment;

public class SelectQueryRunnerFactory
implements QueryRunnerFactory<Result<SelectResultValue>, SelectQuery> {
    private final SelectQueryQueryToolChest toolChest;
    private final SelectQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public SelectQueryRunnerFactory(SelectQueryQueryToolChest toolChest, SelectQueryEngine engine, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> createRunner(Segment segment) {
        return new SelectQueryRunner(this.engine, segment);
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<SelectResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<SelectResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<SelectResultValue>, SelectQuery> getToolchest() {
        return this.toolChest;
    }

    private static class SelectQueryRunner
    implements QueryRunner<Result<SelectResultValue>> {
        private final SelectQueryEngine engine;
        private final Segment segment;

        private SelectQueryRunner(SelectQueryEngine engine, Segment segment) {
            this.engine = engine;
            this.segment = segment;
        }

        @Override
        public Sequence<Result<SelectResultValue>> run(Query<Result<SelectResultValue>> input, Map<String, Object> responseContext) {
            if (!(input instanceof SelectQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", input.getClass(), SelectQuery.class);
            }
            return this.engine.process((SelectQuery)input, this.segment);
        }
    }
}

