/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.search.search;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.search.search.SearchQuerySpec;

public class RegexSearchQuerySpec
implements SearchQuerySpec {
    private static final byte CACHE_TYPE_ID = 3;
    private final String pattern;
    private final Pattern compiled;

    @JsonCreator
    public RegexSearchQuerySpec(@JsonProperty(value="pattern") String pattern) {
        this.pattern = Preconditions.checkNotNull(pattern, "pattern should not be null");
        this.compiled = Pattern.compile(pattern);
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexSearchQuerySpec)) {
            return false;
        }
        RegexSearchQuerySpec that = (RegexSearchQuerySpec)o;
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public boolean accept(String dimVal) {
        if (dimVal == null) {
            return false;
        }
        return this.compiled.matcher(dimVal).find();
    }

    @Override
    public byte[] getCacheKey() {
        byte[] patternBytes = StringUtils.toUtf8(this.pattern);
        return ByteBuffer.allocate(1 + patternBytes.length).put((byte)3).put(patternBytes).array();
    }

    public String toString() {
        return "RegexSearchQuerySpec{pattern=" + this.pattern + "}";
    }
}

