/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.search;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.FunctionalIterable;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.IdentityExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.search.SearchResultValue;
import org.apache.hive.druid.io.druid.query.search.search.SearchHit;
import org.apache.hive.druid.io.druid.query.search.search.SearchQuery;
import org.apache.hive.druid.io.druid.query.search.search.SearchQuerySpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorBitmapIndexSelector;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class SearchQueryRunner
implements QueryRunner<Result<SearchResultValue>> {
    private static final EmittingLogger log = new EmittingLogger(SearchQueryRunner.class);
    private final Segment segment;

    public SearchQueryRunner(Segment segment) {
        this.segment = segment;
    }

    @Override
    public Sequence<Result<SearchResultValue>> run(Query<Result<SearchResultValue>> input, Map<String, Object> responseContext) {
        if (!(input instanceof SearchQuery)) {
            throw new ISE("Got a [%s] which isn't a %s", input.getClass(), SearchQuery.class);
        }
        SearchQuery query = (SearchQuery)input;
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        List<DimensionSpec> dimensions = query.getDimensions();
        final SearchQuerySpec searchQuerySpec = query.getQuery();
        final int limit = query.getLimit();
        boolean descending = query.isDescending();
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", intervals);
        }
        Interval interval = intervals.get(0);
        QueryableIndex index = this.segment.asQueryableIndex();
        if (index != null) {
            ImmutableBitmap timeFilteredBitmap;
            ImmutableBitmap baseFilter;
            TreeMap<SearchHit, MutableInt> retVal = Maps.newTreeMap(query.getSort().getComparator());
            Iterable<DimensionSpec> dimsToSearch = dimensions == null || dimensions.isEmpty() ? Iterables.transform(index.getAvailableDimensions(), Druids.DIMENSION_IDENTITY) : dimensions;
            BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
            ImmutableBitmap immutableBitmap = baseFilter = filter == null ? null : filter.getBitmapIndex(new ColumnSelectorBitmapIndexSelector(bitmapFactory, index));
            if (!interval.contains((ReadableInterval)this.segment.getDataInterval())) {
                MutableBitmap timeBitmap = bitmapFactory.makeEmptyMutableBitmap();
                Column timeColumn = index.getColumn("__time");
                try (GenericColumn timeValues = timeColumn.getGenericColumn();){
                    int startIndex = Math.max(0, this.getStartIndexOfTime(timeValues, interval.getStartMillis(), true));
                    int endIndex = Math.min(timeValues.length() - 1, this.getStartIndexOfTime(timeValues, interval.getEndMillis(), false));
                    for (int i = startIndex; i <= endIndex; ++i) {
                        timeBitmap.add(i);
                    }
                    ImmutableBitmap finalTimeBitmap = bitmapFactory.makeImmutableBitmap(timeBitmap);
                    timeFilteredBitmap = baseFilter == null ? finalTimeBitmap : finalTimeBitmap.intersection(baseFilter);
                }
            } else {
                timeFilteredBitmap = baseFilter;
            }
            for (DimensionSpec dimension : dimsToSearch) {
                Column column = index.getColumn(dimension.getDimension());
                if (column == null) continue;
                BitmapIndex bitmapIndex = column.getBitmapIndex();
                ExtractionFn extractionFn = dimension.getExtractionFn();
                if (extractionFn == null) {
                    extractionFn = IdentityExtractionFn.getInstance();
                }
                if (bitmapIndex == null) continue;
                for (int i = 0; i < bitmapIndex.getCardinality(); ++i) {
                    String dimVal = Strings.nullToEmpty(extractionFn.apply(bitmapIndex.getValue(i)));
                    if (!searchQuerySpec.accept(dimVal)) continue;
                    ImmutableBitmap bitmap = bitmapIndex.getBitmap(i);
                    if (timeFilteredBitmap != null) {
                        bitmap = bitmapFactory.intersection(Arrays.asList(timeFilteredBitmap, bitmap));
                    }
                    if (bitmap.size() <= 0) continue;
                    MutableInt counter = new MutableInt(bitmap.size());
                    MutableInt prev = retVal.put(new SearchHit(dimension.getOutputName(), dimVal), counter);
                    if (prev != null) {
                        counter.add(prev.intValue());
                    }
                    if (retVal.size() < limit) continue;
                    return this.makeReturnResult(limit, retVal);
                }
            }
            return this.makeReturnResult(limit, retVal);
        }
        StorageAdapter adapter = this.segment.asStorageAdapter();
        if (adapter == null) {
            log.makeAlert("WTF!? Unable to process search query on segment.", new Object[0]).addData("segment", this.segment.getIdentifier()).addData("query", query).emit();
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        final Iterable<DimensionSpec> dimsToSearch = dimensions == null || dimensions.isEmpty() ? Iterables.transform(adapter.getAvailableDimensions(), Druids.DIMENSION_IDENTITY) : dimensions;
        Sequence<Cursor> cursors = adapter.makeCursors(filter, interval, query.getGranularity(), descending);
        TreeMap<SearchHit, MutableInt> retVal = cursors.accumulate(Maps.newTreeMap(query.getSort().getComparator()), new Accumulator<TreeMap<SearchHit, MutableInt>, Cursor>(){

            @Override
            public TreeMap<SearchHit, MutableInt> accumulate(TreeMap<SearchHit, MutableInt> set, Cursor cursor) {
                if (set.size() >= limit) {
                    return set;
                }
                HashMap<String, DimensionSelector> dimSelectors = Maps.newHashMap();
                for (DimensionSpec dimensionSpec : dimsToSearch) {
                    dimSelectors.put(dimensionSpec.getOutputName(), cursor.makeDimensionSelector(dimensionSpec));
                }
                while (!cursor.isDone()) {
                    for (Map.Entry entry : dimSelectors.entrySet()) {
                        DimensionSelector selector = (DimensionSelector)entry.getValue();
                        if (selector == null) continue;
                        IndexedInts vals = selector.getRow();
                        for (int i = 0; i < vals.size(); ++i) {
                            String dimVal = selector.lookupName(vals.get(i));
                            if (!searchQuerySpec.accept(dimVal)) continue;
                            MutableInt counter = new MutableInt(1);
                            MutableInt prev = set.put(new SearchHit((String)entry.getKey(), dimVal), counter);
                            if (prev != null) {
                                counter.add(prev.intValue());
                            }
                            if (set.size() < limit) continue;
                            return set;
                        }
                    }
                    cursor.advance();
                }
                return set;
            }
        });
        return this.makeReturnResult(limit, retVal);
    }

    protected int getStartIndexOfTime(GenericColumn timeValues, long time, boolean inclusive) {
        int low = 0;
        int high = timeValues.length() - 1;
        while (low <= high) {
            long prev;
            int i;
            int mid = low + high >>> 1;
            long midVal = timeValues.getLongSingleValueRow(mid);
            if (midVal < time) {
                low = mid + 1;
                continue;
            }
            if (midVal > time) {
                high = mid - 1;
                continue;
            }
            for (i = mid - 1; i >= 0 && time == (prev = timeValues.getLongSingleValueRow(i)); --i) {
            }
            return inclusive ? i + 1 : i;
        }
        return inclusive ? low : low - 1;
    }

    private Sequence<Result<SearchResultValue>> makeReturnResult(int limit, TreeMap<SearchHit, MutableInt> retVal) {
        Iterable<SearchHit> source = Iterables.transform(retVal.entrySet(), new Function<Map.Entry<SearchHit, MutableInt>, SearchHit>(){

            @Override
            public SearchHit apply(Map.Entry<SearchHit, MutableInt> input) {
                SearchHit hit = input.getKey();
                return new SearchHit(hit.getDimension(), hit.getValue(), input.getValue().intValue());
            }
        });
        return Sequences.simple(ImmutableList.of(new Result<SearchResultValue>(this.segment.getDataInterval().getStart(), new SearchResultValue(Lists.newArrayList(new FunctionalIterable<SearchHit>(source).limit(limit))))));
    }
}

