/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.ConcatQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.metadata.SegmentAnalyzer;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.joda.time.Interval;

public class SegmentMetadataQueryRunnerFactory
implements QueryRunnerFactory<SegmentAnalysis, SegmentMetadataQuery> {
    private static final Logger log = new Logger(SegmentMetadataQueryRunnerFactory.class);
    private final SegmentMetadataQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SegmentMetadataQueryRunnerFactory(SegmentMetadataQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<SegmentAnalysis> createRunner(final Segment segment) {
        return new QueryRunner<SegmentAnalysis>(){

            @Override
            public Sequence<SegmentAnalysis> run(Query<SegmentAnalysis> inQ, Map<String, Object> responseContext) {
                QueryGranularity queryGranularity;
                TimestampSpec timestampSpec;
                HashMap<String, AggregatorFactory> aggregators;
                SegmentMetadataQuery query = (SegmentMetadataQuery)inQ;
                SegmentAnalyzer analyzer = new SegmentAnalyzer(query.getAnalysisTypes());
                Map<String, ColumnAnalysis> analyzedColumns = analyzer.analyze(segment);
                long numRows = analyzer.numRows(segment);
                long totalSize = 0L;
                if (analyzer.analyzingSize()) {
                    totalSize = (long)analyzedColumns.size() * numRows;
                }
                TreeMap<String, ColumnAnalysis> columns = Maps.newTreeMap();
                ColumnIncluderator includerator = query.getToInclude();
                for (Map.Entry<String, ColumnAnalysis> entry : analyzedColumns.entrySet()) {
                    String columnName = entry.getKey();
                    AggregatorFactory[] column = entry.getValue();
                    if (!column.isError()) {
                        totalSize += column.getSize();
                    }
                    if (!includerator.include(columnName)) continue;
                    columns.put(columnName, (ColumnAnalysis)column);
                }
                List<Interval> retIntervals = query.analyzingInterval() ? Arrays.asList(segment.getDataInterval()) : null;
                Metadata metadata = null;
                if (query.hasAggregators()) {
                    metadata = segment.asStorageAdapter().getMetadata();
                    if (metadata != null && metadata.getAggregators() != null) {
                        aggregators = Maps.newHashMap();
                        for (AggregatorFactory aggregator : metadata.getAggregators()) {
                            aggregators.put(aggregator.getName(), aggregator);
                        }
                    } else {
                        aggregators = null;
                    }
                } else {
                    aggregators = null;
                }
                if (query.hasTimestampSpec()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    timestampSpec = metadata != null ? metadata.getTimestampSpec() : null;
                } else {
                    timestampSpec = null;
                }
                if (query.hasQueryGranularity()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    queryGranularity = metadata != null ? metadata.getQueryGranularity() : null;
                } else {
                    queryGranularity = null;
                }
                Boolean rollup = null;
                if (query.hasRollup()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    Boolean bl = rollup = metadata != null ? metadata.isRollup() : null;
                    if (rollup == null) {
                        rollup = Boolean.TRUE;
                    }
                }
                return Sequences.simple(Arrays.asList(new SegmentAnalysis(segment.getIdentifier(), retIntervals, columns, totalSize, numRows, aggregators, timestampSpec, queryGranularity, rollup)));
            }
        };
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeRunners(ExecutorService exec, Iterable<QueryRunner<SegmentAnalysis>> queryRunners) {
        final ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator(exec);
        return new ConcatQueryRunner<SegmentAnalysis>(Sequences.map(Sequences.simple(queryRunners), new Function<QueryRunner<SegmentAnalysis>, QueryRunner<SegmentAnalysis>>(){

            @Override
            public QueryRunner<SegmentAnalysis> apply(final QueryRunner<SegmentAnalysis> input) {
                return new QueryRunner<SegmentAnalysis>(){

                    @Override
                    public Sequence<SegmentAnalysis> run(final Query<SegmentAnalysis> query, final Map<String, Object> responseContext) {
                        int priority = BaseQuery.getContextPriority(query, 0);
                        ListenableFuture<Sequence<SegmentAnalysis>> future = queryExecutor.submit(new AbstractPrioritizedCallable<Sequence<SegmentAnalysis>>(priority){

                            @Override
                            public Sequence<SegmentAnalysis> call() throws Exception {
                                return Sequences.simple(Sequences.toList(input.run(query, responseContext), new ArrayList()));
                            }
                        });
                        try {
                            SegmentMetadataQueryRunnerFactory.this.queryWatcher.registerQuery(query, future);
                            Number timeout = query.getContextValue("timeout", null);
                            return timeout == null ? (Sequence)future.get() : (Sequence)future.get(timeout.longValue(), TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            log.warn(e, "Query interrupted, cancelling pending results, query id [%s]", query.getId());
                            future.cancel(true);
                            throw new QueryInterruptedException(e);
                        }
                        catch (CancellationException e) {
                            throw new QueryInterruptedException(e);
                        }
                        catch (TimeoutException e) {
                            log.info("Query timeout, cancelling pending results for query id [%s]", query.getId());
                            future.cancel(true);
                            throw new QueryInterruptedException(e);
                        }
                        catch (ExecutionException e) {
                            throw Throwables.propagate(e.getCause());
                        }
                    }
                };
            }
        }));
    }

    @Override
    public QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> getToolchest() {
        return this.toolChest;
    }
}

