/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.SpillingGrouper;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class ConcurrentGrouper<KeyType extends Comparable<KeyType>>
implements Grouper<KeyType> {
    private final List<SpillingGrouper<KeyType>> groupers;
    private final ThreadLocal<SpillingGrouper<KeyType>> threadLocalGrouper;
    private final AtomicInteger threadNumber = new AtomicInteger();
    private volatile boolean spilling = false;
    private volatile boolean closed = false;

    public ConcurrentGrouper(ByteBuffer buffer, Grouper.KeySerdeFactory<KeyType> keySerdeFactory, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float bufferGrouperMaxLoadFactor, int bufferGrouperInitialBuckets, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, int concurrencyHint) {
        Preconditions.checkArgument(concurrencyHint > 0, "concurrencyHint > 0");
        this.groupers = new ArrayList<SpillingGrouper<KeyType>>(concurrencyHint);
        this.threadLocalGrouper = new ThreadLocal<SpillingGrouper<KeyType>>(){

            @Override
            protected SpillingGrouper<KeyType> initialValue() {
                return (SpillingGrouper)ConcurrentGrouper.this.groupers.get(ConcurrentGrouper.this.threadNumber.getAndIncrement());
            }
        };
        int sliceSize = buffer.capacity() / concurrencyHint;
        for (int i = 0; i < concurrencyHint; ++i) {
            ByteBuffer slice = buffer.duplicate();
            slice.position(sliceSize * i);
            slice.limit(slice.position() + sliceSize);
            this.groupers.add(new SpillingGrouper<KeyType>(slice.slice(), keySerdeFactory, columnSelectorFactory, aggregatorFactories, bufferGrouperMaxSize, bufferGrouperMaxLoadFactor, bufferGrouperInitialBuckets, temporaryStorage, spillMapper, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean aggregate(KeyType key, int keyHash) {
        SpillingGrouper<KeyType> tlGrouper;
        SpillingGrouper<KeyType> spillingGrouper;
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        if (!this.spilling) {
            SpillingGrouper<KeyType> hashBasedGrouper = this.groupers.get(this.grouperNumberForKeyHash(keyHash));
            spillingGrouper = hashBasedGrouper;
            synchronized (spillingGrouper) {
                if (!this.spilling) {
                    if (hashBasedGrouper.aggregate(key, keyHash)) {
                        return true;
                    }
                    this.spilling = true;
                }
            }
        }
        spillingGrouper = tlGrouper = this.threadLocalGrouper.get();
        synchronized (spillingGrouper) {
            tlGrouper.setSpillingAllowed(true);
            return tlGrouper.aggregate(key, keyHash);
        }
    }

    @Override
    public boolean aggregate(KeyType key) {
        return this.aggregate(key, Groupers.hash(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        Iterator<SpillingGrouper<KeyType>> iterator = this.groupers.iterator();
        while (iterator.hasNext()) {
            Grouper grouper;
            Grouper grouper2 = grouper = (Grouper)iterator.next();
            synchronized (grouper2) {
                grouper.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        ArrayList iterators = new ArrayList(this.groupers.size());
        Iterator<SpillingGrouper<KeyType>> iterator = this.groupers.iterator();
        while (iterator.hasNext()) {
            Grouper grouper;
            Grouper grouper2 = grouper = (Grouper)iterator.next();
            synchronized (grouper2) {
                iterators.add(grouper.iterator(sorted));
            }
        }
        return Groupers.mergeIterators(iterators, sorted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        Iterator<SpillingGrouper<KeyType>> iterator = this.groupers.iterator();
        while (iterator.hasNext()) {
            Grouper grouper;
            Grouper grouper2 = grouper = (Grouper)iterator.next();
            synchronized (grouper2) {
                grouper.close();
            }
        }
    }

    private int grouperNumberForKeyHash(int keyHash) {
        return keyHash % this.groupers.size();
    }
}

