/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.nio.ByteBuffer;
import java.util.Locale;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.granularity.QueryGranularities;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimeFormatExtractionFn
implements ExtractionFn {
    private final DateTimeZone tz;
    private final String format;
    private final Locale locale;
    private final QueryGranularity granularity;
    private final DateTimeFormatter formatter;

    public TimeFormatExtractionFn(@JsonProperty(value="format") String format, @JsonProperty(value="timeZone") DateTimeZone tz, @JsonProperty(value="locale") String localeString, @JsonProperty(value="granularity") QueryGranularity granularity) {
        this.format = format;
        this.tz = tz;
        this.locale = localeString == null ? null : Locale.forLanguageTag(localeString);
        this.granularity = granularity == null ? QueryGranularities.NONE : granularity;
        this.formatter = (format == null ? ISODateTimeFormat.dateTime() : DateTimeFormat.forPattern((String)format)).withZone(tz == null ? DateTimeZone.UTC : tz).withLocale(this.locale);
    }

    @JsonProperty
    public DateTimeZone getTimeZone() {
        return this.tz;
    }

    @JsonProperty
    public String getFormat() {
        return this.format;
    }

    @JsonProperty
    public String getLocale() {
        if (this.locale != null) {
            return this.locale.toLanguageTag();
        }
        return null;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] exprBytes = StringUtils.toUtf8(this.format + "\u0001" + this.tz.getID() + "\u0001" + this.locale.toLanguageTag());
        byte[] granularityCacheKey = this.granularity.cacheKey();
        return ByteBuffer.allocate(2 + exprBytes.length + granularityCacheKey.length).put((byte)5).put(exprBytes).put((byte)-1).put(granularityCacheKey).array();
    }

    @Override
    public String apply(long value) {
        return this.formatter.print(this.granularity.truncate(value));
    }

    @Override
    public String apply(Object value) {
        return this.apply(new DateTime(value).getMillis());
    }

    @Override
    public String apply(String value) {
        return this.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeFormatExtractionFn that = (TimeFormatExtractionFn)o;
        if (this.tz != null ? !this.tz.equals((Object)that.tz) : that.tz != null) {
            return false;
        }
        if (this.format != null ? !this.format.equals(that.format) : that.format != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        return this.granularity.equals(that.granularity);
    }

    public int hashCode() {
        int result = this.tz != null ? this.tz.hashCode() : 0;
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + this.granularity.hashCode();
        return result;
    }
}

