/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.dimension;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.dimension.BaseFilteredDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;

public class RegexFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 2;
    private final String pattern;
    private final Pattern compiledRegex;

    public RegexFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="pattern") String pattern) {
        super(delegate);
        this.pattern = Preconditions.checkNotNull(pattern, "pattern must not be null");
        this.compiledRegex = Pattern.compile(pattern);
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return selector;
        }
        int count = 0;
        HashMap<Integer, Integer> forwardMapping = new HashMap<Integer, Integer>();
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0) {
            throw new UnsupportedOperationException("Cannot decorate a selector with no dictionary");
        }
        for (int i = 0; i < selectorCardinality; ++i) {
            if (!this.compiledRegex.matcher(Strings.nullToEmpty(selector.lookupName(i))).matches()) continue;
            forwardMapping.put(i, count++);
        }
        int[] reverseMapping = new int[forwardMapping.size()];
        for (Map.Entry e : forwardMapping.entrySet()) {
            reverseMapping[((Integer)e.getValue()).intValue()] = (Integer)e.getKey();
        }
        return BaseFilteredDimensionSpec.decorate(selector, forwardMapping, reverseMapping);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[] regexBytes = StringUtils.toUtf8(this.pattern);
        return ByteBuffer.allocate(2 + delegateCacheKey.length + regexBytes.length).put((byte)2).put(delegateCacheKey).put((byte)-1).put(regexBytes).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexFilteredDimensionSpec that = (RegexFilteredDimensionSpec)o;
        if (!this.delegate.equals(that.delegate)) {
            return false;
        }
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    public String toString() {
        return "RegexFilteredDimensionSpec{pattern='" + this.pattern + '\'' + '}';
    }
}

