/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.datasourcemetadata;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DataSourceMetadataQuery
extends BaseQuery<Result<DataSourceMetadataResultValue>> {
    public static final Interval MY_Y2K_INTERVAL = new Interval(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);

    @JsonCreator
    public DataSourceMetadataQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec == null ? new MultipleIntervalSegmentSpec(Arrays.asList(MY_Y2K_INTERVAL)) : querySegmentSpec, false, context);
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public DimFilter getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "dataSourceMetadata";
    }

    public DataSourceMetadataQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        return new DataSourceMetadataQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.computeOverridenContext(contextOverrides));
    }

    public DataSourceMetadataQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new DataSourceMetadataQuery(this.getDataSource(), spec, this.getContext());
    }

    @Override
    public Query<Result<DataSourceMetadataResultValue>> withDataSource(DataSource dataSource) {
        return new DataSourceMetadataQuery(dataSource, this.getQuerySegmentSpec(), this.getContext());
    }

    public Iterable<Result<DataSourceMetadataResultValue>> buildResult(DateTime timestamp, DateTime maxIngestedEventTime) {
        return Arrays.asList(new Result<DataSourceMetadataResultValue>(timestamp, new DataSourceMetadataResultValue(maxIngestedEventTime)));
    }

    public Iterable<Result<DataSourceMetadataResultValue>> mergeResults(List<Result<DataSourceMetadataResultValue>> results) {
        if (results == null || results.isEmpty()) {
            return Lists.newArrayList();
        }
        DateTime max = new DateTime(-4611686018427387904L);
        for (Result<DataSourceMetadataResultValue> result : results) {
            DateTime currMaxIngestedEventTime = result.getValue().getMaxIngestedEventTime();
            if (currMaxIngestedEventTime == null || !currMaxIngestedEventTime.isAfter((ReadableInstant)max)) continue;
            max = currMaxIngestedEventTime;
        }
        return this.buildResult(max, max);
    }

    public String toString() {
        return "DataSourceMetadataQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", duration=" + this.getDuration() + '}';
    }
}

