/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;

public class HyperUniquesBufferAggregator
implements BufferAggregator {
    private static final byte[] EMPTY_BYTES = HyperLogLogCollector.makeEmptyVersionedByteArray();
    private final ObjectColumnSelector selector;

    public HyperUniquesBufferAggregator(ObjectColumnSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.put(EMPTY_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position) {
        HyperLogLogCollector collector = (HyperLogLogCollector)this.selector.get();
        if (collector == null) {
            return;
        }
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
        buf.position(position);
        try {
            HyperLogLogCollector.makeCollector(buf).fold(collector);
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        int size = HyperLogLogCollector.getLatestNumBytesForDenseStorage();
        ByteBuffer dataCopyBuffer = ByteBuffer.allocate(size);
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.limit(position + size);
        dataCopyBuffer.put(mutationBuffer);
        dataCopyBuffer.rewind();
        return HyperLogLogCollector.makeCollector(dataCopyBuffer);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HyperUniquesBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HyperUniquesBufferAggregator does not support getLong()");
    }

    @Override
    public void close() {
    }
}

