/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.FilteredAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.FilteredBufferAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class FilteredAggregatorFactory
extends AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 9;
    private final AggregatorFactory delegate;
    private final DimFilter filter;

    public FilteredAggregatorFactory(@JsonProperty(value="aggregator") AggregatorFactory delegate, @JsonProperty(value="filter") DimFilter filter) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(filter);
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        FilteredAggregatorValueMatcherFactory valueMatcherFactory = new FilteredAggregatorValueMatcherFactory(columnSelectorFactory);
        ValueMatcher valueMatcher = Filters.toFilter(this.filter).makeMatcher(valueMatcherFactory);
        return new FilteredAggregator(valueMatcher, this.delegate.factorize(columnSelectorFactory));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        FilteredAggregatorValueMatcherFactory valueMatcherFactory = new FilteredAggregatorValueMatcherFactory(columnSelectorFactory);
        ValueMatcher valueMatcher = Filters.toFilter(this.filter).makeMatcher(valueMatcherFactory);
        return new FilteredBufferAggregator(valueMatcher, this.delegate.factorizeBuffered(columnSelectorFactory));
    }

    @Override
    public Comparator getComparator() {
        return this.delegate.getComparator();
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return this.delegate.combine(lhs, rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return this.delegate.getCombiningFactory();
    }

    @Override
    public Object deserialize(Object object) {
        return this.delegate.deserialize(object);
    }

    @Override
    public Object finalizeComputation(Object object) {
        return this.delegate.finalizeComputation(object);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public List<String> requiredFields() {
        return this.delegate.requiredFields();
    }

    @Override
    public byte[] getCacheKey() {
        byte[] filterCacheKey = this.filter.getCacheKey();
        byte[] aggregatorCacheKey = this.delegate.getCacheKey();
        return ByteBuffer.allocate(1 + filterCacheKey.length + aggregatorCacheKey.length).put((byte)9).put(filterCacheKey).put(aggregatorCacheKey).array();
    }

    @Override
    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    @Override
    public int getMaxIntermediateSize() {
        return this.delegate.getMaxIntermediateSize();
    }

    @Override
    public Object getAggregatorStartValue() {
        return this.delegate.getAggregatorStartValue();
    }

    @JsonProperty
    public AggregatorFactory getAggregator() {
        return this.delegate;
    }

    @JsonProperty
    public DimFilter getFilter() {
        return this.filter;
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return this.delegate.getRequiredColumns();
    }

    public String toString() {
        return "FilteredAggregatorFactory{, delegate=" + this.delegate + ", filter=" + this.filter + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredAggregatorFactory that = (FilteredAggregatorFactory)o;
        if (this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null) {
            return false;
        }
        return !(this.filter != null ? !this.filter.equals(that.filter) : that.filter != null);
    }

    public int hashCode() {
        int result = this.delegate != null ? this.delegate.hashCode() : 0;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }

    private static class FilteredAggregatorValueMatcherFactory
    implements ValueMatcherFactory {
        private final ColumnSelectorFactory columnSelectorFactory;

        public FilteredAggregatorValueMatcherFactory(ColumnSelectorFactory columnSelectorFactory) {
            this.columnSelectorFactory = columnSelectorFactory;
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, Comparable value) {
            String valueString;
            if (this.getTypeForDimension(dimension) == ValueType.LONG) {
                return Filters.getLongValueMatcher(this.columnSelectorFactory.makeLongColumnSelector(dimension), value);
            }
            final DimensionSelector selector = this.columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(dimension, dimension));
            String string = valueString = value == null ? null : Strings.emptyToNull(value.toString());
            if (selector == null) {
                return new BooleanValueMatcher(valueString == null);
            }
            int cardinality = selector.getValueCardinality();
            if (cardinality >= 0) {
                final int valueId = selector.lookupId(valueString);
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        IndexedInts row = selector.getRow();
                        int size = row.size();
                        if (size == 0) {
                            return valueString == null;
                        }
                        for (int i = 0; i < size; ++i) {
                            if (row.get(i) != valueId) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    IndexedInts row = selector.getRow();
                    int size = row.size();
                    if (size == 0) {
                        return valueString == null;
                    }
                    for (int i = 0; i < size; ++i) {
                        if (!Objects.equals(selector.lookupName(row.get(i)), valueString)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, DruidPredicateFactory predicateFactory) {
            ValueType type = this.getTypeForDimension(dimension);
            switch (type) {
                case LONG: {
                    return this.makeLongValueMatcher(dimension, predicateFactory.makeLongPredicate());
                }
                case STRING: {
                    return this.makeStringValueMatcher(dimension, predicateFactory.makeStringPredicate());
                }
            }
            return new BooleanValueMatcher(predicateFactory.makeStringPredicate().apply(null));
        }

        public ValueMatcher makeStringValueMatcher(String dimension, final Predicate<String> predicate) {
            final DimensionSelector selector = this.columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(dimension, dimension));
            final boolean doesMatchNull = predicate.apply(null);
            if (selector == null) {
                return new BooleanValueMatcher(doesMatchNull);
            }
            int cardinality = selector.getValueCardinality();
            if (cardinality >= 0) {
                final BitSet valueIds = new BitSet(cardinality);
                for (int i = 0; i < cardinality; ++i) {
                    if (!predicate.apply(selector.lookupName(i))) continue;
                    valueIds.set(i);
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        IndexedInts row = selector.getRow();
                        int size = row.size();
                        if (size == 0) {
                            return doesMatchNull;
                        }
                        for (int i = 0; i < size; ++i) {
                            if (!valueIds.get(row.get(i))) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    IndexedInts row = selector.getRow();
                    int size = row.size();
                    if (size == 0) {
                        return doesMatchNull;
                    }
                    for (int i = 0; i < size; ++i) {
                        if (!predicate.apply(selector.lookupName(row.get(i)))) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private ValueMatcher makeLongValueMatcher(String dimension, DruidLongPredicate predicate) {
            return Filters.getLongPredicateMatcher(this.columnSelectorFactory.makeLongColumnSelector(dimension), predicate);
        }

        private ValueType getTypeForDimension(String dimension) {
            if (dimension.equals("__time")) {
                return ValueType.LONG;
            }
            ColumnCapabilities capabilities = this.columnSelectorFactory.getColumnCapabilities(dimension);
            return capabilities == null ? ValueType.STRING : capabilities.getType();
        }
    }
}

