/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.IOException;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;

public class MetricsEmittingQueryRunner<T>
implements QueryRunner<T> {
    private final ServiceEmitter emitter;
    private final Function<Query<T>, ServiceMetricEvent.Builder> builderFn;
    private final QueryRunner<T> queryRunner;
    private final long creationTime;
    private final String metricName;
    private final Map<String, String> userDimensions;

    private MetricsEmittingQueryRunner(ServiceEmitter emitter, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, QueryRunner<T> queryRunner, long creationTime, String metricName, Map<String, String> userDimensions) {
        this.emitter = emitter;
        this.builderFn = builderFn;
        this.queryRunner = queryRunner;
        this.creationTime = creationTime;
        this.metricName = metricName;
        this.userDimensions = userDimensions;
    }

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, QueryRunner<T> queryRunner, String metricName, Map<String, String> userDimensions) {
        this(emitter, builderFn, queryRunner, -1L, metricName, userDimensions);
    }

    public MetricsEmittingQueryRunner<T> withWaitMeasuredFromNow() {
        return new MetricsEmittingQueryRunner<T>(this.emitter, this.builderFn, this.queryRunner, System.currentTimeMillis(), this.metricName, this.userDimensions);
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        final ServiceMetricEvent.Builder builder = this.builderFn.apply(query);
        for (Map.Entry<String, String> userDimension : this.userDimensions.entrySet()) {
            builder.setDimension(userDimension.getKey(), userDimension.getValue());
        }
        return new Sequence<T>(){

            @Override
            public <OutType> OutType accumulate(OutType outType, Accumulator<OutType, T> accumulator) {
                OutType retVal;
                long startTime = System.currentTimeMillis();
                try {
                    retVal = MetricsEmittingQueryRunner.this.queryRunner.run(query, responseContext).accumulate(outType, accumulator);
                }
                catch (RuntimeException e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                catch (Error e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                finally {
                    long timeTaken = System.currentTimeMillis() - startTime;
                    MetricsEmittingQueryRunner.this.emitter.emit(builder.build(MetricsEmittingQueryRunner.this.metricName, timeTaken));
                    if (MetricsEmittingQueryRunner.this.creationTime > 0L) {
                        MetricsEmittingQueryRunner.this.emitter.emit(builder.build("query/wait/time", startTime - MetricsEmittingQueryRunner.this.creationTime));
                    }
                }
                return retVal;
            }

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                Yielder<OutType> retVal;
                long startTime = System.currentTimeMillis();
                try {
                    retVal = MetricsEmittingQueryRunner.this.queryRunner.run(query, responseContext).toYielder(initValue, accumulator);
                }
                catch (RuntimeException e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                catch (Error e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                return this.makeYielder(startTime, retVal, builder);
            }

            private <OutType> Yielder<OutType> makeYielder(final long startTime, final Yielder<OutType> yielder, final ServiceMetricEvent.Builder builder2) {
                return new Yielder<OutType>(){

                    @Override
                    public OutType get() {
                        return yielder.get();
                    }

                    @Override
                    public Yielder<OutType> next(OutType initValue) {
                        try {
                            return this.makeYielder(startTime, yielder.next(initValue), builder2);
                        }
                        catch (RuntimeException e) {
                            builder2.setDimension("status", "failed");
                            throw e;
                        }
                        catch (Error e) {
                            builder2.setDimension("status", "failed");
                            throw e;
                        }
                    }

                    @Override
                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    @Override
                    public void close() throws IOException {
                        try {
                            if (!this.isDone() && builder2.getDimension("status") == null) {
                                builder2.setDimension("status", "short");
                            }
                            long timeTaken = System.currentTimeMillis() - startTime;
                            MetricsEmittingQueryRunner.this.emitter.emit(builder2.build(MetricsEmittingQueryRunner.this.metricName, timeTaken));
                            if (MetricsEmittingQueryRunner.this.creationTime > 0L) {
                                MetricsEmittingQueryRunner.this.emitter.emit(builder2.build("query/wait/time", startTime - MetricsEmittingQueryRunner.this.creationTime));
                            }
                        }
                        finally {
                            yielder.close();
                        }
                    }
                };
            }
        };
    }
}

