/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.FunctionalIterable;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.granularity.PeriodGranularity;
import org.apache.hive.druid.io.druid.query.AsyncQueryRunner;
import org.apache.hive.druid.io.druid.query.MetricsEmittingQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.joda.time.Interval;
import org.joda.time.Period;

public class IntervalChunkingQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final QueryToolChest<T, Query<T>> toolChest;
    private final ExecutorService executor;
    private final QueryWatcher queryWatcher;
    private final ServiceEmitter emitter;

    public IntervalChunkingQueryRunner(QueryRunner<T> baseRunner, QueryToolChest<T, Query<T>> toolChest, ExecutorService executor, QueryWatcher queryWatcher, ServiceEmitter emitter) {
        this.baseRunner = baseRunner;
        this.toolChest = toolChest;
        this.executor = executor;
        this.queryWatcher = queryWatcher;
        this.emitter = emitter;
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        final Period chunkPeriod = this.getChunkPeriod(query);
        if (chunkPeriod.toStandardDuration().getMillis() == 0L) {
            return this.baseRunner.run(query, responseContext);
        }
        ArrayList<Interval> chunkIntervals = Lists.newArrayList(FunctionalIterable.create(query.getIntervals()).transformCat(new Function<Interval, Iterable<Interval>>(){

            @Override
            public Iterable<Interval> apply(Interval input) {
                return IntervalChunkingQueryRunner.this.splitInterval(input, chunkPeriod);
            }
        }));
        if (chunkIntervals.size() <= 1) {
            return this.baseRunner.run(query, responseContext);
        }
        return Sequences.concat(Lists.newArrayList(FunctionalIterable.create(chunkIntervals).transform(new Function<Interval, Sequence<T>>(){

            @Override
            public Sequence<T> apply(Interval singleInterval) {
                return new AsyncQueryRunner(IntervalChunkingQueryRunner.this.toolChest.mergeResults(new MetricsEmittingQueryRunner(IntervalChunkingQueryRunner.this.emitter, new Function<Query<T>, ServiceMetricEvent.Builder>(){

                    @Override
                    public ServiceMetricEvent.Builder apply(Query<T> input) {
                        return IntervalChunkingQueryRunner.this.toolChest.makeMetricBuilder(input);
                    }
                }, IntervalChunkingQueryRunner.this.baseRunner, "query/intervalChunk/time", ImmutableMap.of("chunkInterval", singleInterval.toString())).withWaitMeasuredFromNow()), IntervalChunkingQueryRunner.this.executor, IntervalChunkingQueryRunner.this.queryWatcher).run(query.withQuerySegmentSpec(new MultipleIntervalSegmentSpec(Arrays.asList(singleInterval))), responseContext);
            }
        })));
    }

    private Iterable<Interval> splitInterval(Interval interval, Period period) {
        if (interval.getEndMillis() == interval.getStartMillis()) {
            return Lists.newArrayList(interval);
        }
        ArrayList<Interval> intervals = Lists.newArrayList();
        Iterator<Long> timestamps = new PeriodGranularity(period, null, null).iterable(interval.getStartMillis(), interval.getEndMillis()).iterator();
        long start = Math.max(timestamps.next(), interval.getStartMillis());
        while (timestamps.hasNext()) {
            long end = timestamps.next();
            intervals.add(new Interval(start, end));
            start = end;
        }
        if (start < interval.getEndMillis()) {
            intervals.add(new Interval(start, interval.getEndMillis()));
        }
        return intervals;
    }

    private Period getChunkPeriod(Query<T> query) {
        String p = query.getContextValue("chunkPeriod", "P0D");
        return Period.parse((String)p);
    }
}

