/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.joda.time.DateTime;

public class BySegmentQueryRunner<T>
implements QueryRunner<T> {
    private final String segmentIdentifier;
    private final DateTime timestamp;
    private final QueryRunner<T> base;

    public BySegmentQueryRunner(String segmentIdentifier, DateTime timestamp, QueryRunner<T> base) {
        this.segmentIdentifier = segmentIdentifier;
        this.timestamp = timestamp;
        this.base = base;
    }

    @Override
    public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
        if (BaseQuery.getContextBySegment(query, false)) {
            Sequence<T> baseSequence = this.base.run(query, responseContext);
            ArrayList results = Sequences.toList(baseSequence, Lists.newArrayList());
            return Sequences.simple(Arrays.asList(new Result(this.timestamp, new BySegmentResultValueClass(results, this.segmentIdentifier, query.getIntervals().get(0)))));
        }
        return this.base.run(query, responseContext);
    }
}

