/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata.storage.derby;

import com.google.inject.Inject;
import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.metadata.MetadataStorage;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageConnectorConfig;

@ManageLifecycle
public class DerbyMetadataStorage
extends MetadataStorage {
    private static final Logger log = new Logger(DerbyMetadataStorage.class);
    private final NetworkServerControl server;

    @Inject
    public DerbyMetadataStorage(MetadataStorageConnectorConfig config) {
        try {
            this.server = new NetworkServerControl(InetAddress.getByName(config.getHost()), config.getPort());
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    @LifecycleStart
    public void start() {
        try {
            log.info("Starting Derby Metadata Storage", new Object[0]);
            this.server.start(null);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    @LifecycleStop
    public void stop() {
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

