/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprListenerImpl;
import org.apache.hive.druid.io.druid.math.expr.Function;
import org.apache.hive.druid.io.druid.math.expr.antlr.ExprLexer;
import org.apache.hive.druid.io.druid.math.expr.antlr.ExprParser;

public class Parser {
    static final Logger log = new Logger(Parser.class);
    static final Map<String, Function> func;

    public static Expr parse(String in) {
        ExprLexer lexer = new ExprLexer((CharStream)new ANTLRInputStream(in));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        ExprParser.ExprContext parseTree = parser.expr();
        ParseTreeWalker walker = new ParseTreeWalker();
        ExprListenerImpl listener = new ExprListenerImpl((ParseTree)parseTree);
        walker.walk((ParseTreeListener)listener, (ParseTree)parseTree);
        return listener.getAST();
    }

    static {
        HashMap<String, Function> functionMap = Maps.newHashMap();
        for (Class<?> clazz : Function.class.getClasses()) {
            if (Modifier.isAbstract(clazz.getModifiers()) || !Function.class.isAssignableFrom(clazz)) continue;
            try {
                Function function = (Function)clazz.newInstance();
                functionMap.put(function.name().toLowerCase(), function);
            }
            catch (Exception e) {
                log.info("failed to instantiate " + clazz.getName() + ".. ignoring", e);
            }
        }
        func = ImmutableMap.copyOf(functionMap);
    }
}

