/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.indexer;

import com.google.inject.Inject;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.indexer.MetadataStorageUpdaterJobHandler;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataStorageUpdaterJobHandler
implements MetadataStorageUpdaterJobHandler {
    private static final Logger log = new Logger(SQLMetadataStorageUpdaterJobHandler.class);
    private final IDBI dbi;

    @Inject
    public SQLMetadataStorageUpdaterJobHandler(SQLMetadataConnector connector) {
        this.dbi = connector.getDBI();
    }

    @Override
    public void publishSegments(final String tableName, final List<DataSegment> segments, final ObjectMapper mapper) {
        this.dbi.withHandle(new HandleCallback<Void>(){

            @Override
            public Void withHandle(Handle handle) throws Exception {
                PreparedBatch batch = handle.prepareBatch(String.format("INSERT INTO %s (id, dataSource, created_date, start, \"end\", partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", tableName));
                for (DataSegment segment : segments) {
                    batch.add(new ImmutableMap.Builder<String, String>().put("id", segment.getIdentifier()).put("dataSource", segment.getDataSource()).put("created_date", new DateTime().toString()).put("start", segment.getInterval().getStart().toString()).put("end", segment.getInterval().getEnd().toString()).put("partitioned", (String)((Object)Boolean.valueOf(!(segment.getShardSpec() instanceof NoneShardSpec)))).put("version", segment.getVersion()).put("used", (String)((Object)Boolean.valueOf(true))).put("payload", (String)mapper.writeValueAsBytes(segment)).build());
                    log.info("Published %s", segment.getIdentifier());
                }
                batch.execute();
                return null;
            }
        });
    }
}

