/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.druid.com.metamx.common.concurrent.ExecutorServiceConfig;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.common.utils.VMUtils;
import org.apache.hive.druid.io.druid.guice.ConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.BackgroundCaching;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.guice.annotations.Merging;
import org.apache.hive.druid.io.druid.guice.annotations.Processing;
import org.apache.hive.druid.io.druid.offheap.OffheapBufferGenerator;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.io.druid.query.ExecutorServiceMonitor;
import org.apache.hive.druid.io.druid.query.MetricsEmittingExecutorService;
import org.apache.hive.druid.io.druid.query.PrioritizedExecutorService;
import org.apache.hive.druid.io.druid.server.metrics.MetricsModule;

public class DruidProcessingModule
implements Module {
    private static final Logger log = new Logger(DruidProcessingModule.class);

    public void configure(Binder binder) {
        ConfigProvider.bind(binder, DruidProcessingConfig.class, ImmutableMap.of("base_path", "druid.processing"));
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @BackgroundCaching
    @LazySingleton
    public ExecutorService getBackgroundExecutorService(CacheConfig cacheConfig) {
        if (cacheConfig.getNumBackgroundThreads() > 0) {
            return Executors.newFixedThreadPool(cacheConfig.getNumBackgroundThreads(), new ThreadFactoryBuilder().setNameFormat("background-cacher-%d").setDaemon(true).setPriority(1).build());
        }
        return MoreExecutors.sameThreadExecutor();
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(DruidProcessingConfig config, ExecutorServiceMonitor executorServiceMonitor, Lifecycle lifecycle) {
        return new MetricsEmittingExecutorService(PrioritizedExecutorService.create(lifecycle, config), executorServiceMonitor);
    }

    @Provides
    @LazySingleton
    @Global
    public StupidPool<ByteBuffer> getIntermediateResultsPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new StupidPool<ByteBuffer>(new OffheapBufferGenerator("intermediate processing", config.intermediateComputeSizeBytes()), config.poolCacheMaxCount());
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new BlockingPool<ByteBuffer>(new OffheapBufferGenerator("result merging", config.intermediateComputeSizeBytes()), config.getNumMergeBuffers());
    }

    private void verifyDirectMemory(DruidProcessingConfig config) {
        try {
            long maxDirectMemory = VMUtils.getMaxDirectMemory();
            long memoryNeeded = (long)config.intermediateComputeSizeBytes() * (long)(config.getNumMergeBuffers() + config.getNumThreads() + 1);
            if (maxDirectMemory < memoryNeeded) {
                throw new ProvisionException(String.format("Not enough direct memory.  Please adjust -XX:MaxDirectMemorySize, druid.processing.buffer.sizeBytes, druid.processing.numThreads, or druid.processing.numMergeBuffers: maxDirectMemory[%,d], memoryNeeded[%,d] = druid.processing.buffer.sizeBytes[%,d] * (druid.processing.numMergeBuffers[%,d] + druid.processing.numThreads[%,d] + 1)", maxDirectMemory, memoryNeeded, config.intermediateComputeSizeBytes(), config.getNumMergeBuffers(), config.getNumThreads()));
            }
        }
        catch (UnsupportedOperationException e) {
            log.info("Could not verify that you have enough direct memory, so I hope you do! Error message was: %s", e.getMessage());
        }
    }
}

