/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=StringDimensionSchema.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="string", value=StringDimensionSchema.class), @JsonSubTypes.Type(name="long", value=LongDimensionSchema.class), @JsonSubTypes.Type(name="float", value=FloatDimensionSchema.class), @JsonSubTypes.Type(name="spatial", value=NewSpatialDimensionSchema.class)})
public abstract class DimensionSchema {
    public static final String STRING_TYPE_NAME = "string";
    public static final String LONG_TYPE_NAME = "long";
    public static final String FLOAT_TYPE_NAME = "float";
    public static final String SPATIAL_TYPE_NAME = "spatial";
    private final String name;

    protected DimensionSchema(String name) {
        this.name = Preconditions.checkNotNull(name, "Dimension name cannot be null.");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public abstract String getTypeName();

    @JsonIgnore
    public abstract ValueType getValueType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionSchema that = (DimensionSchema)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum ValueType {
        FLOAT,
        LONG,
        STRING,
        COMPLEX;


        @JsonValue
        public String toString() {
            return this.name().toUpperCase();
        }

        @JsonCreator
        public static ValueType fromString(String name) {
            return ValueType.valueOf(name.toUpperCase());
        }
    }
}

