/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.config;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.audit.AuditEntry;
import org.apache.hive.druid.io.druid.audit.AuditInfo;
import org.apache.hive.druid.io.druid.audit.AuditManager;
import org.apache.hive.druid.io.druid.common.config.ConfigManager;
import org.apache.hive.druid.io.druid.common.config.ConfigSerde;

public class JacksonConfigManager {
    private final ConfigManager configManager;
    private final ObjectMapper jsonMapper;
    private final AuditManager auditManager;

    @Inject
    public JacksonConfigManager(ConfigManager configManager, ObjectMapper jsonMapper, AuditManager auditManager) {
        this.configManager = configManager;
        this.jsonMapper = jsonMapper;
        this.auditManager = auditManager;
    }

    public <T> AtomicReference<T> watch(String key, Class<? extends T> clazz) {
        return this.watch(key, clazz, null);
    }

    public <T> AtomicReference<T> watch(String key, Class<? extends T> clazz, T defaultVal) {
        return this.configManager.watchConfig(key, this.create(clazz, defaultVal));
    }

    public <T> AtomicReference<T> watch(String key, TypeReference<T> clazz) {
        return this.watch(key, clazz, null);
    }

    public <T> AtomicReference<T> watch(String key, TypeReference<T> clazz, T defaultVal) {
        return this.configManager.watchConfig(key, this.create(clazz, defaultVal));
    }

    public <T> boolean set(String key, T val, AuditInfo auditInfo) {
        ConfigSerde<Object> configSerde = this.create(val.getClass(), null);
        this.auditManager.doAudit(AuditEntry.builder().key(key).type(key).auditInfo(auditInfo).payload(configSerde.serializeToString(val)).build());
        return this.configManager.set(key, configSerde, val);
    }

    private <T> ConfigSerde<T> create(final Class<? extends T> clazz, final T defaultVal) {
        return new ConfigSerde<T>(){

            @Override
            public byte[] serialize(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsBytes(obj);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public String serializeToString(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsString(obj);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public T deserialize(byte[] bytes) {
                if (bytes == null) {
                    return defaultVal;
                }
                try {
                    return JacksonConfigManager.this.jsonMapper.readValue(bytes, clazz);
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }
        };
    }

    private <T> ConfigSerde<T> create(final TypeReference<? extends T> clazz, final T defaultVal) {
        return new ConfigSerde<T>(){

            @Override
            public byte[] serialize(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsBytes(obj);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public String serializeToString(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsString(obj);
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public T deserialize(byte[] bytes) {
                if (bytes == null) {
                    return defaultVal;
                }
                try {
                    return JacksonConfigManager.this.jsonMapper.readValue(bytes, clazz);
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }
        };
    }
}

