/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.collections.Releaser;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;

public class ReferenceCountingResourceHolder<T>
implements ResourceHolder<T> {
    private static final Logger log = new Logger(ReferenceCountingResourceHolder.class);
    private final Object lock = new Object();
    private final T object;
    private final Closeable closer;
    private int refcount = 1;
    private boolean didClose = false;

    public ReferenceCountingResourceHolder(T object, Closeable closer) {
        this.object = object;
        this.closer = closer;
    }

    public static <T extends Closeable> ReferenceCountingResourceHolder<T> fromCloseable(T object) {
        return new ReferenceCountingResourceHolder<T>(object, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refcount <= 0) {
                throw new ISE("Already closed!", new Object[0]);
            }
            return this.object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Releaser increment() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refcount <= 0) {
                throw new ISE("Already closed!", new Object[0]);
            }
            ++this.refcount;
            return new Releaser(){
                final AtomicBoolean didRelease = new AtomicBoolean();

                @Override
                public void close() {
                    if (this.didRelease.compareAndSet(false, true)) {
                        ReferenceCountingResourceHolder.this.decrement();
                    } else {
                        log.warn("WTF?! release called but we are already released!", new Object[0]);
                    }
                }

                protected void finalize() throws Throwable {
                    if (this.didRelease.compareAndSet(false, true)) {
                        log.warn("Not released! Object was[%s], releasing on finalize of releaser.", ReferenceCountingResourceHolder.this.object);
                        ReferenceCountingResourceHolder.this.decrement();
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReferenceCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.refcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.didClose) {
                this.didClose = true;
                this.decrement();
            } else {
                log.warn(new ISE("Already closed!", new Object[0]), "Already closed", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.lock;
        synchronized (object) {
            if (!this.didClose) {
                log.warn("Not closed! Object was[%s], closing on finalize of holder.", this.object);
                this.didClose = true;
                this.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrement() {
        Object object = this.lock;
        synchronized (object) {
            --this.refcount;
            if (this.refcount <= 0) {
                try {
                    this.closer.close();
                }
                catch (Exception e) {
                    log.error(e, "WTF?! Close failed, uh oh...", new Object[0]);
                }
            }
        }
    }
}

