/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.joda.time.Interval;

public class CacheUtil {
    public static Cache.NamedKey computeSegmentCacheKey(String segmentIdentifier, SegmentDescriptor descriptor, byte[] queryCacheKey) {
        Interval segmentQueryInterval = descriptor.getInterval();
        byte[] versionBytes = StringUtils.toUtf8(descriptor.getVersion());
        return new Cache.NamedKey(segmentIdentifier, ByteBuffer.allocate(16 + versionBytes.length + 4 + queryCacheKey.length).putLong(segmentQueryInterval.getStartMillis()).putLong(segmentQueryInterval.getEndMillis()).put(versionBytes).putInt(descriptor.getPartitionNumber()).put(queryCacheKey).array());
    }

    public static void populate(Cache cache, ObjectMapper mapper, Cache.NamedKey key, Iterable<Object> results) {
        try {
            ArrayList<byte[]> bytes = Lists.newArrayList();
            int size = 0;
            for (Object result : results) {
                byte[] array = mapper.writeValueAsBytes(result);
                size += array.length;
                bytes.add(array);
            }
            byte[] valueBytes = new byte[size];
            int offset = 0;
            for (byte[] array : bytes) {
                System.arraycopy(array, 0, valueBytes, offset, array.length);
                offset += array.length;
            }
            cache.put(key, valueBytes);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }
}

