/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.metrics;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.StreamUtils;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.metrics.SysMonitor;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;

public class SigarUtil {
    private static final Logger log = new Logger(SigarUtil.class);

    public static Sigar getSigar() {
        return new Sigar();
    }

    static {
        SigarLoader loader = new SigarLoader(Sigar.class);
        try {
            String libName = loader.getLibraryName();
            URL url = SysMonitor.class.getResource("/" + libName);
            if (url != null) {
                File tmpDir = File.createTempFile("yay", "yay");
                tmpDir.delete();
                tmpDir.mkdir();
                File nativeLibTmpFile = new File(tmpDir, libName);
                nativeLibTmpFile.deleteOnExit();
                StreamUtils.copyToFileAndClose(url.openStream(), nativeLibTmpFile);
                log.info("Loading sigar native lib at tmpPath[%s]", nativeLibTmpFile);
                loader.load(nativeLibTmpFile.getParent());
            } else {
                log.info("No native libs found in jar, letting the normal load mechanisms figger it out.", new Object[0]);
            }
        }
        catch (IOException | ArchLoaderException | ArchNotSupportedException e) {
            throw Throwables.propagate(e);
        }
    }
}

