/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.Accumulators;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.ConcatSequence;
import org.apache.hive.druid.com.metamx.common.guava.ExecuteWhenDoneYielder;
import org.apache.hive.druid.com.metamx.common.guava.FilteredSequence;
import org.apache.hive.druid.com.metamx.common.guava.LimitedSequence;
import org.apache.hive.druid.com.metamx.common.guava.MappedSequence;
import org.apache.hive.druid.com.metamx.common.guava.ResourceClosingSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.Yielders;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;

public class Sequences {
    private static final EmptySequence EMPTY_SEQUENCE = new EmptySequence();

    public static <T> Sequence<T> simple(Iterable<T> iterable) {
        return BaseSequence.simple(iterable);
    }

    public static <T> Sequence<T> empty() {
        return EMPTY_SEQUENCE;
    }

    public static <T> Sequence<T> concat(Sequence<T> ... sequences) {
        return Sequences.concat(Arrays.asList(sequences));
    }

    public static <T> Sequence<T> concat(Iterable<Sequence<T>> sequences) {
        return Sequences.concat(Sequences.simple(sequences));
    }

    public static <T> Sequence<T> concat(Sequence<Sequence<T>> sequences) {
        return new ConcatSequence<T>(sequences);
    }

    public static <From, To> Sequence<To> map(Sequence<From> sequence, Function<From, To> fn) {
        return new MappedSequence<From, To>(sequence, fn);
    }

    public static <T> Sequence<T> filter(Sequence<T> sequence, Predicate<T> pred) {
        return new FilteredSequence<T>(sequence, pred);
    }

    public static <T> Sequence<T> limit(Sequence<T> sequence, int limit) {
        return new LimitedSequence<T>(sequence, limit);
    }

    public static <T> Sequence<T> withBaggage(Sequence<T> seq, Closeable baggage) {
        return new ResourceClosingSequence<T>(seq, baggage);
    }

    public static <T> Sequence<T> withEffect(final Sequence<T> seq, final Runnable effect, final Executor exec) {
        return new Sequence<T>(){

            @Override
            public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                OutType out = seq.accumulate(initValue, accumulator);
                exec.execute(effect);
                return out;
            }

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                return new ExecuteWhenDoneYielder<OutType>(seq.toYielder(initValue, accumulator), effect, exec);
            }
        };
    }

    public static <T> Sequence<T> sort(Sequence<T> sequence, Comparator<T> comparator) {
        ArrayList seqList = Sequences.toList(sequence, Lists.newArrayList());
        Collections.sort(seqList, comparator);
        return BaseSequence.simple(seqList);
    }

    public static <T, ListType extends List<T>> ListType toList(Sequence<T> seq, ListType list) {
        return seq.accumulate(list, Accumulators.list());
    }

    private static class EmptySequence
    implements Sequence<Object> {
        private EmptySequence() {
        }

        @Override
        public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, Object> accumulator) {
            return initValue;
        }

        @Override
        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, Object> accumulator) {
            return Yielders.done(initValue, null);
        }
    }
}

