/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.UOE;

public class ByteBufferUtils {
    private static final Method unmap;
    private static final Method getCleaner;
    private static final Method clean;

    public static void free(ByteBuffer buffer) {
        try {
            clean.invoke(getCleaner.invoke((Object)buffer, new Object[0]), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate(e);
        }
    }

    public static void unmap(MappedByteBuffer buffer) {
        try {
            unmap.invoke(null, buffer);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    static {
        try {
            Method unmapMethod = Class.forName("sun.nio.ch.FileChannelImpl").getDeclaredMethod("unmap", MappedByteBuffer.class);
            unmapMethod.setAccessible(true);
            unmap = unmapMethod;
        }
        catch (Exception e) {
            throw new UOE(e, "Exception thrown while trying to find unmap method on MappedByteBuffer, this method must exist in your VM in order for this to work", new Object[0]);
        }
        try {
            getCleaner = Class.forName("java.nio.DirectByteBuffer").getDeclaredMethod("cleaner", new Class[0]);
            getCleaner.setAccessible(true);
            clean = Class.forName("sun.misc.Cleaner").getDeclaredMethod("clean", new Class[0]);
            clean.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new UOE("Exception thrown while trying to access ByteBuffer clean method.", new Object[0]);
        }
    }
}

