/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.DruidRecordWriter;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.Granularity;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.CustomVersioningPolicy;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusher;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidOutputFormat<K, V>
implements HiveOutputFormat<K, DruidWritable> {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidOutputFormat.class);

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        String segmentGranularity = tableProperties.getProperty("druid.segment.granularity") != null ? tableProperties.getProperty("druid.segment.granularity") : HiveConf.getVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_INDEXING_GRANULARITY);
        String dataSource = tableProperties.getProperty("druid.datasource");
        String segmentDirectory = tableProperties.getProperty("druid.storage.storageDirectory") != null ? tableProperties.getProperty("druid.storage.storageDirectory") : HiveConf.getVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.DRUID_SEGMENT_DIRECTORY);
        HdfsDataSegmentPusherConfig hdfsDataSegmentPusherConfig = new HdfsDataSegmentPusherConfig();
        hdfsDataSegmentPusherConfig.setStorageDirectory(segmentDirectory);
        HdfsDataSegmentPusher hdfsDataSegmentPusher = new HdfsDataSegmentPusher(hdfsDataSegmentPusherConfig, (Configuration)jc, DruidStorageHandlerUtils.JSON_MAPPER);
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularity.valueOf(segmentGranularity), QueryGranularity.fromString(tableProperties.getProperty("druid.query.granularity") == null ? "NONE" : tableProperties.getProperty("druid.query.granularity")), null);
        String columnNameProperty = tableProperties.getProperty("columns");
        String columnTypeProperty = tableProperties.getProperty("columns.types");
        if (StringUtils.isEmpty((String)columnNameProperty) || StringUtils.isEmpty((String)columnTypeProperty)) {
            throw new IllegalStateException(String.format("List of columns names [%s] or columns type [%s] is/are not present", columnNameProperty, columnTypeProperty));
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (String name : columnNameProperty.split(",")) {
            columnNames.add(name);
        }
        if (!columnNames.contains("__time")) {
            throw new IllegalStateException("Timestamp column (' __time') not specified in create table; list of columns is : " + tableProperties.getProperty("columns"));
        }
        ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        ArrayList<DimensionSchema> dimensions = new ArrayList<DimensionSchema>();
        ImmutableList.Builder aggregatorFactoryBuilder = ImmutableList.builder();
        block6: for (int i = 0; i < columnTypes.size(); ++i) {
            AggregatorFactory af;
            PrimitiveTypeInfo f = (PrimitiveTypeInfo)columnTypes.get(i);
            switch (f.getPrimitiveCategory()) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    af = new LongSumAggregatorFactory((String)columnNames.get(i), (String)columnNames.get(i));
                    break;
                }
                case FLOAT: 
                case DOUBLE: 
                case DECIMAL: {
                    af = new DoubleSumAggregatorFactory((String)columnNames.get(i), (String)columnNames.get(i));
                    break;
                }
                case TIMESTAMP: {
                    String tColumnName = (String)columnNames.get(i);
                    if (tColumnName.equals("__time") || tColumnName.equals("__time_granularity")) continue block6;
                    throw new IOException("Dimension " + tColumnName + " does not have STRING type: " + f.getPrimitiveCategory());
                }
                default: {
                    String dColumnName = (String)columnNames.get(i);
                    if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)f.getPrimitiveCategory()) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
                        throw new IOException("Dimension " + dColumnName + " does not have STRING type: " + f.getPrimitiveCategory());
                    }
                    dimensions.add(new StringDimensionSchema(dColumnName));
                    continue block6;
                }
            }
            aggregatorFactoryBuilder.add(af);
        }
        ImmutableCollection aggregatorFactories = aggregatorFactoryBuilder.build();
        MapInputRowParser inputRowParser = new MapInputRowParser(new TimeAndDimsParseSpec(new TimestampSpec("__time", "auto", null), new DimensionsSpec(dimensions, Lists.newArrayList("__time_granularity"), null)));
        Map inputParser = DruidStorageHandlerUtils.JSON_MAPPER.convertValue((Object)inputRowParser, Map.class);
        DataSchema dataSchema = new DataSchema(Preconditions.checkNotNull(dataSource, "Data source name is null"), inputParser, aggregatorFactories.toArray(new AggregatorFactory[aggregatorFactories.size()]), granularitySpec, DruidStorageHandlerUtils.JSON_MAPPER);
        String workingPath = jc.get("druid.job.workingDirectory");
        String version = jc.get("druid.segment.version");
        Integer maxPartitionSize = HiveConf.getIntVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_MAX_PARTITION_SIZE);
        String basePersistDirectory = HiveConf.getVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BASE_PERSIST_DIRECTORY);
        if (Strings.isNullOrEmpty(basePersistDirectory)) {
            basePersistDirectory = System.getProperty("java.io.tmpdir");
        }
        Integer maxRowInMemory = HiveConf.getIntVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_MAX_ROW_IN_MEMORY);
        RealtimeTuningConfig realtimeTuningConfig = new RealtimeTuningConfig(maxRowInMemory, null, null, new File(basePersistDirectory, dataSource), new CustomVersioningPolicy(version), null, null, null, null, true, 0, 0, true, null);
        LOG.debug(String.format("running with Data schema [%s] ", dataSchema));
        return new DruidRecordWriter(dataSchema, realtimeTuningConfig, hdfsDataSegmentPusher, maxPartitionSize, new Path(workingPath, "segmentsDescriptorDir"), finalOutPath.getFileSystem((Configuration)jc));
    }

    public RecordWriter<K, DruidWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("please implement me !");
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
    }
}

