/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.wrappers;

import it.uniroma3.mat.extendedset.AbstractExtendedSet;
import it.uniroma3.mat.extendedset.ExtendedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class GenericExtendedSet<T extends Comparable<T>>
extends AbstractExtendedSet<T> {
    private Collection<T> elements;
    private final Class<? extends Collection> setClass;

    public GenericExtendedSet(Class<? extends Collection> setClass) {
        this.setClass = setClass;
        try {
            this.elements = setClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double bitmapCompressionRatio() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double collectionCompressionRatio() {
        return this.isEmpty() ? 0.0 : 1.0;
    }

    @Override
    public GenericExtendedSet<T> empty() {
        return new GenericExtendedSet<T>(this.setClass);
    }

    @Override
    public ExtendedSet.ExtendedIterator<T> iterator() {
        Collection<T> sorted;
        if (this.elements instanceof SortedSet || this.elements instanceof List) {
            sorted = this.elements;
        } else {
            sorted = new ArrayList<T>(this.elements);
            Collections.sort((List)sorted);
        }
        return new ExtendedSet.ExtendedIterator<T>(){
            final Iterator<T> itr;
            T current;
            {
                this.itr = sorted.iterator();
                this.current = this.itr.hasNext() ? (Comparable)this.itr.next() : null;
            }

            @Override
            public void skipAllBefore(T element) {
                while (element.compareTo(this.current) > 0) {
                    this.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object prev = this.current;
                this.current = this.itr.hasNext() ? (Comparable)this.itr.next() : null;
                return prev;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ExtendedSet.ExtendedIterator<T> descendingIterator() {
        final ArrayList<T> sorted = new ArrayList<T>(this.elements);
        Collections.sort((List)sorted, Collections.reverseOrder());
        return new ExtendedSet.ExtendedIterator<T>(){
            final Iterator<T> itr;
            T current;
            {
                this.itr = sorted.iterator();
                this.current = this.itr.hasNext() ? (Comparable)this.itr.next() : null;
            }

            @Override
            public void skipAllBefore(T element) {
                while (element.compareTo(this.current) > 0) {
                    this.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object prev = this.current;
                this.current = this.itr.hasNext() ? (Comparable)this.itr.next() : null;
                return prev;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public GenericExtendedSet<T> clone() {
        ExtendedSet c = this.empty();
        if (this.elements instanceof Cloneable) {
            try {
                ((GenericExtendedSet)c).elements = (Collection)this.elements.getClass().getMethod("clone", new Class[0]).invoke(this.elements, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            ((GenericExtendedSet)c).elements.addAll(this.elements);
        }
        return c;
    }

    @Override
    public String debugInfo() {
        return this.setClass.getSimpleName() + ": " + this.elements.toString();
    }

    @Override
    public boolean add(T e) {
        if (this.elements instanceof List) {
            List l = (List)this.elements;
            int pos = Collections.binarySearch(l, e);
            if (pos >= 0) {
                return false;
            }
            l.add(-(pos + 1), e);
            return true;
        }
        return this.elements.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.elements instanceof List) {
            try {
                List l = (List)this.elements;
                int pos = Collections.binarySearch(l, (Comparable)o);
                if (pos < 0) {
                    return false;
                }
                l.remove(pos);
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.elements.remove(o);
    }

    @Override
    public boolean contains(Object o) {
        if (this.elements instanceof List) {
            try {
                return Collections.binarySearch((List)this.elements, (Comparable)o) >= 0;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.isEmpty() || c == null || c.isEmpty()) {
            return false;
        }
        if (this == c) {
            return true;
        }
        if (this.elements instanceof List && c instanceof GenericExtendedSet && ((GenericExtendedSet)c).elements instanceof List) {
            Iterator<T> thisItr = this.elements.iterator();
            Iterator<T> otherItr = ((GenericExtendedSet)c).elements.iterator();
            while (thisItr.hasNext() && otherItr.hasNext()) {
                int r;
                Comparable thisValue = (Comparable)thisItr.next();
                Comparable otherValue = (Comparable)otherItr.next();
                while ((r = otherValue.compareTo(thisValue)) > 0) {
                    if (!thisItr.hasNext()) {
                        return false;
                    }
                    thisValue = (Comparable)thisItr.next();
                }
                if (r >= 0) continue;
                return false;
            }
            return !otherItr.hasNext();
        }
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.elements instanceof List) {
            Collection<T> res = ((GenericExtendedSet)this.union(c)).elements;
            boolean r = !res.equals(this.elements);
            this.elements = res;
            return r;
        }
        return this.elements.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.elements instanceof List) {
            try {
                Collection<T> res = ((GenericExtendedSet)this.intersection(c)).elements;
                boolean r = !res.equals(this.elements);
                this.elements = res;
                return r;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.elements.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.elements instanceof List) {
            try {
                Collection<T> res = ((GenericExtendedSet)this.difference(c)).elements;
                boolean r = !res.equals(this.elements);
                this.elements = res;
                return r;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.elements.removeAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof GenericExtendedSet && ((GenericExtendedSet)o).elements.equals(this.elements);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public Comparator<? super T> comparator() {
        return null;
    }

    @Override
    public T first() {
        if (this.elements instanceof SortedSet) {
            return (T)((Comparable)((SortedSet)this.elements).first());
        }
        if (this.elements instanceof List) {
            return (T)((Comparable)((List)this.elements).get(0));
        }
        return (T)((Comparable)super.first());
    }

    @Override
    public T last() {
        if (this.elements instanceof SortedSet) {
            return (T)((Comparable)((SortedSet)this.elements).last());
        }
        if (this.elements instanceof List) {
            return (T)((Comparable)((List)this.elements).get(this.elements.size() - 1));
        }
        return (T)((Comparable)super.last());
    }

    @Override
    public ExtendedSet<T> headSet(T toElement) {
        if (this.elements instanceof SortedSet) {
            ExtendedSet c = this.empty();
            ((GenericExtendedSet)c).elements = ((SortedSet)this.elements).headSet(toElement);
            return c;
        }
        return super.headSet((Object)toElement);
    }

    @Override
    public ExtendedSet<T> tailSet(T fromElement) {
        if (this.elements instanceof SortedSet) {
            ExtendedSet c = this.empty();
            ((GenericExtendedSet)c).elements = ((SortedSet)this.elements).tailSet(fromElement);
            return c;
        }
        return super.headSet((Object)fromElement);
    }

    @Override
    public ExtendedSet<T> subSet(T fromElement, T toElement) {
        if (this.elements instanceof SortedSet) {
            ExtendedSet c = this.empty();
            ((GenericExtendedSet)c).elements = ((SortedSet)this.elements).subSet(fromElement, toElement);
            return c;
        }
        return super.headSet((Object)toElement);
    }

    @Override
    public int intersectionSize(Collection<? extends T> other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return 0;
        }
        if (this == other) {
            return this.size();
        }
        if (this.elements instanceof List && other instanceof GenericExtendedSet && ((GenericExtendedSet)other).elements instanceof List) {
            int res = 0;
            Iterator<T> thisItr = this.elements.iterator();
            Iterator<T> otherItr = ((GenericExtendedSet)other).elements.iterator();
            while (thisItr.hasNext() && otherItr.hasNext()) {
                Comparable thisValue = (Comparable)thisItr.next();
                Comparable otherValue = (Comparable)otherItr.next();
                int r = thisValue.compareTo(otherValue);
                while (r != 0) {
                    while ((r = thisValue.compareTo(otherValue)) > 0) {
                        if (!otherItr.hasNext()) {
                            return res;
                        }
                        otherValue = (Comparable)otherItr.next();
                    }
                    if (r == 0) break;
                    while ((r = otherValue.compareTo(thisValue)) > 0) {
                        if (!thisItr.hasNext()) {
                            return res;
                        }
                        thisValue = (Comparable)thisItr.next();
                    }
                }
                ++res;
            }
            return res;
        }
        return super.intersectionSize(other);
    }

    @Override
    public GenericExtendedSet<T> intersection(Collection<? extends T> other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return this.empty();
        }
        if (this == other) {
            return this.clone();
        }
        if (this.elements instanceof List && other instanceof GenericExtendedSet && ((GenericExtendedSet)other).elements instanceof List) {
            ExtendedSet res = this.empty();
            Iterator<T> thisItr = this.elements.iterator();
            Iterator<T> otherItr = ((GenericExtendedSet)other).elements.iterator();
            while (thisItr.hasNext() && otherItr.hasNext()) {
                Comparable thisValue = (Comparable)thisItr.next();
                Comparable otherValue = (Comparable)otherItr.next();
                int r = thisValue.compareTo(otherValue);
                while (r != 0) {
                    while ((r = thisValue.compareTo(otherValue)) > 0) {
                        if (!otherItr.hasNext()) {
                            return res;
                        }
                        otherValue = (Comparable)otherItr.next();
                    }
                    if (r == 0) break;
                    while ((r = otherValue.compareTo(thisValue)) > 0) {
                        if (!thisItr.hasNext()) {
                            return res;
                        }
                        thisValue = (Comparable)thisItr.next();
                    }
                }
                ((GenericExtendedSet)res).elements.add(thisValue);
            }
            return res;
        }
        ExtendedSet clone = this.clone();
        ((GenericExtendedSet)clone).elements.retainAll(other);
        return clone;
    }

    @Override
    public GenericExtendedSet<T> union(Collection<? extends T> other) {
        if (this == other || other == null || other.isEmpty()) {
            return this.clone();
        }
        if (this.isEmpty()) {
            ExtendedSet res = this.empty();
            ((GenericExtendedSet)res).elements.addAll(other);
            return res;
        }
        if (this.elements instanceof List && other instanceof GenericExtendedSet && ((GenericExtendedSet)other).elements instanceof List) {
            ExtendedSet res = this.empty();
            Iterator<T> thisItr = this.elements.iterator();
            Iterator<T> otherItr = ((GenericExtendedSet)other).elements.iterator();
            block0: while (thisItr.hasNext() && otherItr.hasNext()) {
                Comparable thisValue = (Comparable)thisItr.next();
                Comparable otherValue = (Comparable)otherItr.next();
                int r = thisValue.compareTo(otherValue);
                while (r != 0) {
                    while ((r = thisValue.compareTo(otherValue)) > 0) {
                        ((GenericExtendedSet)res).elements.add(otherValue);
                        if (!otherItr.hasNext()) {
                            ((GenericExtendedSet)res).elements.add(thisValue);
                            break block0;
                        }
                        otherValue = (Comparable)otherItr.next();
                    }
                    if (r == 0) break;
                    while ((r = otherValue.compareTo(thisValue)) > 0) {
                        ((GenericExtendedSet)res).elements.add(thisValue);
                        if (!thisItr.hasNext()) {
                            ((GenericExtendedSet)res).elements.add(otherValue);
                            break block0;
                        }
                        thisValue = (Comparable)thisItr.next();
                    }
                }
                ((GenericExtendedSet)res).elements.add(thisValue);
            }
            while (thisItr.hasNext()) {
                ((GenericExtendedSet)res).elements.add(thisItr.next());
            }
            while (otherItr.hasNext()) {
                ((GenericExtendedSet)res).elements.add(otherItr.next());
            }
            return res;
        }
        ExtendedSet clone = this.clone();
        for (Comparable e : other) {
            ((GenericExtendedSet)clone).add((T)e);
        }
        return clone;
    }

    @Override
    public GenericExtendedSet<T> difference(Collection<? extends T> other) {
        if (this.isEmpty() || this == other) {
            return this.empty();
        }
        if (other == null || other.isEmpty()) {
            return this.clone();
        }
        if (this.elements instanceof List && other instanceof GenericExtendedSet && ((GenericExtendedSet)other).elements instanceof List) {
            ExtendedSet res = this.empty();
            Iterator<T> thisItr = this.elements.iterator();
            Iterator<T> otherItr = ((GenericExtendedSet)other).elements.iterator();
            block0: while (thisItr.hasNext() && otherItr.hasNext()) {
                Comparable thisValue = (Comparable)thisItr.next();
                Comparable otherValue = (Comparable)otherItr.next();
                int r = thisValue.compareTo(otherValue);
                while (r != 0) {
                    while ((r = thisValue.compareTo(otherValue)) > 0) {
                        if (!otherItr.hasNext()) {
                            ((GenericExtendedSet)res).elements.add(thisValue);
                            break block0;
                        }
                        otherValue = (Comparable)otherItr.next();
                    }
                    if (r == 0) continue block0;
                    while ((r = otherValue.compareTo(thisValue)) > 0) {
                        ((GenericExtendedSet)res).elements.add(thisValue);
                        if (!thisItr.hasNext()) break block0;
                        thisValue = (Comparable)thisItr.next();
                    }
                }
            }
            while (thisItr.hasNext()) {
                ((GenericExtendedSet)res).elements.add(thisItr.next());
            }
            return res;
        }
        ExtendedSet clone = this.clone();
        ((GenericExtendedSet)clone).elements.removeAll(other);
        return clone;
    }

    @Override
    public GenericExtendedSet<T> symmetricDifference(Collection<? extends T> other) {
        if (this == other || other == null || other.isEmpty()) {
            return this.clone();
        }
        if (this.isEmpty()) {
            ExtendedSet res = this.empty();
            ((GenericExtendedSet)res).elements.addAll(other);
            return res;
        }
        if (this.elements instanceof List && other instanceof GenericExtendedSet && ((GenericExtendedSet)other).elements instanceof List) {
            ExtendedSet res = this.empty();
            Iterator<T> thisItr = this.elements.iterator();
            Iterator<T> otherItr = ((GenericExtendedSet)other).elements.iterator();
            block0: while (thisItr.hasNext() && otherItr.hasNext()) {
                Comparable thisValue = (Comparable)thisItr.next();
                Comparable otherValue = (Comparable)otherItr.next();
                int r = thisValue.compareTo(otherValue);
                while (r != 0) {
                    while ((r = thisValue.compareTo(otherValue)) > 0) {
                        ((GenericExtendedSet)res).elements.add(otherValue);
                        if (!otherItr.hasNext()) {
                            ((GenericExtendedSet)res).elements.add(thisValue);
                            break block0;
                        }
                        otherValue = (Comparable)otherItr.next();
                    }
                    if (r == 0) continue block0;
                    while ((r = otherValue.compareTo(thisValue)) > 0) {
                        ((GenericExtendedSet)res).elements.add(thisValue);
                        if (!thisItr.hasNext()) {
                            ((GenericExtendedSet)res).elements.add(otherValue);
                            break block0;
                        }
                        thisValue = (Comparable)thisItr.next();
                    }
                }
            }
            while (thisItr.hasNext()) {
                ((GenericExtendedSet)res).elements.add(thisItr.next());
            }
            while (otherItr.hasNext()) {
                ((GenericExtendedSet)res).elements.add(otherItr.next());
            }
            return res;
        }
        ExtendedSet clone = this.union(other);
        ((GenericExtendedSet)clone).removeAll(this.intersection(other));
        return clone;
    }

    @Override
    public void complement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExtendedSet<T> unmodifiable() {
        ExtendedSet c = this.empty();
        ((GenericExtendedSet)c).elements = Collections.unmodifiableCollection(this.elements);
        return c;
    }

    @Override
    public void fill(T from, T to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericExtendedSet<T> convert(Collection<?> c) {
        GenericExtendedSet res = (GenericExtendedSet)super.convert(c);
        if (res.elements instanceof List) {
            Collections.sort((List)res.elements);
        }
        return res;
    }

    @Override
    public GenericExtendedSet<T> convert(Object ... e) {
        GenericExtendedSet res = (GenericExtendedSet)super.convert(e);
        if (res.elements instanceof List) {
            Collections.sort((List)res.elements);
        }
        return res;
    }
}

