/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.io.DruidQueryBasedInputFormat;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;
import org.junit.Test;

public class TestHiveDruidQueryBasedInputFormat
extends TestCase {
    private static final String TIMESERIES_QUERY = "{  \"queryType\": \"timeseries\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"descending\": \"true\",  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ]}";
    private static final String TIMESERIES_QUERY_SPLIT = "[HiveDruidSplit{{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"sample_datasource\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2012-01-01T00:00:00.000-08:00/2012-01-03T00:00:00.000-08:00\"]},\"descending\":true,\"filter\":null,\"granularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1969-12-31T16:00:00.000-08:00\"},\"aggregations\":[],\"postAggregations\":[],\"context\":null}, [localhost:8082]}]";
    private static final String TOPN_QUERY = "{  \"queryType\": \"topN\",  \"dataSource\": \"sample_data\",  \"dimension\": \"sample_dim\",  \"threshold\": 5,  \"metric\": \"count\",  \"aggregations\": [    {      \"type\": \"longSum\",      \"name\": \"count\",      \"fieldName\": \"count\"    },    {      \"type\": \"doubleSum\",      \"name\": \"some_metric\",      \"fieldName\": \"some_metric\"    }  ],  \"granularity\": \"all\",  \"intervals\": [    \"2013-08-31T00:00:00.000/2013-09-03T00:00:00.000\"  ]}";
    private static final String TOPN_QUERY_SPLIT = "[HiveDruidSplit{{\"queryType\":\"topN\",\"dataSource\":{\"type\":\"table\",\"name\":\"sample_data\"},\"dimension\":{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"sample_dim\",\"outputName\":\"sample_dim\"},\"metric\":{\"type\":\"LegacyTopNMetricSpec\",\"metric\":\"count\"},\"threshold\":5,\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2013-08-31T00:00:00.000-07:00/2013-09-03T00:00:00.000-07:00\"]},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"longSum\",\"name\":\"count\",\"fieldName\":\"count\"},{\"type\":\"doubleSum\",\"name\":\"some_metric\",\"fieldName\":\"some_metric\"}],\"postAggregations\":[],\"context\":null,\"descending\":false}, [localhost:8082]}]";
    private static final String GROUP_BY_QUERY = "{  \"queryType\": \"groupBy\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"dimensions\": [\"country\", \"device\"],  \"limitSpec\": { \"type\": \"default\", \"limit\": 5000, \"columns\": [\"country\", \"data_transfer\"] },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"total_usage\", \"fieldName\": \"user_count\" },    { \"type\": \"doubleSum\", \"name\": \"data_transfer\", \"fieldName\": \"data_transfer\" }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ] }";
    private static final String GROUP_BY_QUERY_SPLIT = "[HiveDruidSplit{{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"sample_datasource\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2012-01-01T00:00:00.000-08:00/2012-01-03T00:00:00.000-08:00\"]},\"filter\":null,\"granularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1969-12-31T16:00:00.000-08:00\"},\"dimensions\":[{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"country\",\"outputName\":\"country\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"device\",\"outputName\":\"device\"}],\"aggregations\":[{\"type\":\"longSum\",\"name\":\"total_usage\",\"fieldName\":\"user_count\"},{\"type\":\"doubleSum\",\"name\":\"data_transfer\",\"fieldName\":\"data_transfer\"}],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"default\",\"columns\":[{\"dimension\":\"country\",\"direction\":\"ascending\",\"dimensionOrder\":{\"type\":\"lexicographic\"}},{\"dimension\":\"data_transfer\",\"direction\":\"ascending\",\"dimensionOrder\":{\"type\":\"lexicographic\"}}],\"limit\":5000},\"context\":null,\"descending\":false}, [localhost:8082]}]";
    private static final String SELECT_QUERY = "{   \"queryType\": \"select\",   \"dataSource\": \"wikipedia\",   \"descending\": \"false\",   \"dimensions\":[\"robot\",\"namespace\",\"anonymous\",\"unpatrolled\",\"page\",\"language\",\"newpage\",\"user\"],   \"metrics\":[\"count\",\"added\",\"delta\",\"variation\",\"deleted\"],   \"granularity\": \"all\",   \"intervals\": [     \"2013-01-01/2013-01-02\"   ],   \"pagingSpec\":{\"pagingIdentifiers\": {}, \"threshold\":5},  \"context\":{\"druid.query.fetch\":true}}";
    private static final String SELECT_QUERY_SPLIT = "[HiveDruidSplit{{\"queryType\":\"select\",\"dataSource\":{\"type\":\"table\",\"name\":\"wikipedia\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2013-01-01T00:00:00.000-08:00/2013-01-02T00:00:00.000-08:00\"]},\"descending\":false,\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"robot\",\"outputName\":\"robot\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"namespace\",\"outputName\":\"namespace\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"anonymous\",\"outputName\":\"anonymous\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"unpatrolled\",\"outputName\":\"unpatrolled\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"page\",\"outputName\":\"page\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"language\",\"outputName\":\"language\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"newpage\",\"outputName\":\"newpage\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"user\",\"outputName\":\"user\"}],\"metrics\":[\"count\",\"added\",\"delta\",\"variation\",\"deleted\"],\"pagingSpec\":{\"pagingIdentifiers\":{},\"threshold\":5,\"fromNext\":false},\"context\":{\"druid.query.fetch\":true}}, [localhost:8082]}]";

    @Test
    public void testCreateSplitsIntervals() throws Exception {
        DruidQueryBasedInputFormat input = new DruidQueryBasedInputFormat();
        Method method1 = DruidQueryBasedInputFormat.class.getDeclaredMethod("createSplitsIntervals", List.class, Integer.TYPE);
        method1.setAccessible(true);
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval(1262304000000L, 1293840000000L, (Chronology)ISOChronology.getInstanceUTC()));
        List resultList = (List)method1.invoke((Object)input, intervals, 4);
        ArrayList<List<Interval>> expectedResultList = new ArrayList<List<Interval>>();
        expectedResultList.add(Arrays.asList(new Interval(1262304000000L, 1270188000000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1270188000000L, 1278072000000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1278072000000L, 1285956000000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1285956000000L, 1293840000000L, (Chronology)ISOChronology.getInstanceUTC())));
        TestHiveDruidQueryBasedInputFormat.assertEquals(expectedResultList, (Object)resultList);
        intervals = new ArrayList();
        intervals.add(new Interval(1262304000000L, 1293840000000L, (Chronology)ISOChronology.getInstanceUTC()));
        intervals.add(new Interval(1325376000000L, 1356998400000L, (Chronology)ISOChronology.getInstanceUTC()));
        resultList = (List)method1.invoke((Object)input, intervals, 4);
        expectedResultList = new ArrayList();
        expectedResultList.add(Arrays.asList(new Interval(1262304000000L, 1278093600000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1278093600000L, 1293840000000L, (Chronology)ISOChronology.getInstanceUTC()), new Interval(1325376000000L, 1325419200000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1325419200000L, 1341208800000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1341208800000L, 1356998400000L, (Chronology)ISOChronology.getInstanceUTC())));
        TestHiveDruidQueryBasedInputFormat.assertEquals(expectedResultList, (Object)resultList);
        intervals = new ArrayList();
        intervals.add(new Interval(1262304000000L, 1293840000000L, (Chronology)ISOChronology.getInstanceUTC()));
        intervals.add(new Interval(1325376000000L, 1356998400000L, (Chronology)ISOChronology.getInstanceUTC()));
        resultList = (List)method1.invoke((Object)input, intervals, 5);
        expectedResultList = new ArrayList();
        expectedResultList.add(Arrays.asList(new Interval(1262304000000L, 1274935680000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1274935680000L, 1287567360000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1287567360000L, 1293840000000L, (Chronology)ISOChronology.getInstanceUTC()), new Interval(1325376000000L, 1331735040000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1331735040000L, 1344366720000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1344366720000L, 1356998400000L, (Chronology)ISOChronology.getInstanceUTC())));
        TestHiveDruidQueryBasedInputFormat.assertEquals(expectedResultList, (Object)resultList);
        intervals = new ArrayList();
        intervals.add(new Interval(1199145600000L, 1201824000000L, (Chronology)ISOChronology.getInstanceUTC()));
        intervals.add(new Interval(1325376000000L, 1356998400000L, (Chronology)ISOChronology.getInstanceUTC()));
        intervals.add(new Interval(1407283200000L, 1407888000000L, (Chronology)ISOChronology.getInstanceUTC()));
        resultList = (List)method1.invoke((Object)input, intervals, 6);
        expectedResultList = new ArrayList();
        expectedResultList.add(Arrays.asList(new Interval(1199145600000L, 1201824000000L, (Chronology)ISOChronology.getInstanceUTC()), new Interval(1325376000000L, 1328515200000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1328515200000L, 1334332800000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1334332800000L, 1340150400000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1340150400000L, 1345968000000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1345968000000L, 1351785600000L, (Chronology)ISOChronology.getInstanceUTC())));
        expectedResultList.add(Arrays.asList(new Interval(1351785600000L, 1356998400000L, (Chronology)ISOChronology.getInstanceUTC()), new Interval(1407283200000L, 1407888000000L, (Chronology)ISOChronology.getInstanceUTC())));
        TestHiveDruidQueryBasedInputFormat.assertEquals(expectedResultList, (Object)resultList);
    }

    @Test
    public void testTimeZone() throws Exception {
        DruidQueryBasedInputFormat input = new DruidQueryBasedInputFormat();
        Method method1 = DruidQueryBasedInputFormat.class.getDeclaredMethod("getInputSplits", Configuration.class);
        method1.setAccessible(true);
        Configuration conf = TestHiveDruidQueryBasedInputFormat.createPropertiesQuery("sample_datasource", "timeseries", TIMESERIES_QUERY);
        Object[] resultSplits = (HiveDruidSplit[])method1.invoke((Object)input, conf);
        TestHiveDruidQueryBasedInputFormat.assertEquals((String)TIMESERIES_QUERY_SPLIT, (String)Arrays.toString(resultSplits));
        conf = TestHiveDruidQueryBasedInputFormat.createPropertiesQuery("sample_datasource", "topN", TOPN_QUERY);
        resultSplits = (HiveDruidSplit[])method1.invoke((Object)input, conf);
        TestHiveDruidQueryBasedInputFormat.assertEquals((String)TOPN_QUERY_SPLIT, (String)Arrays.toString(resultSplits));
        conf = TestHiveDruidQueryBasedInputFormat.createPropertiesQuery("sample_datasource", "groupBy", GROUP_BY_QUERY);
        resultSplits = (HiveDruidSplit[])method1.invoke((Object)input, conf);
        TestHiveDruidQueryBasedInputFormat.assertEquals((String)GROUP_BY_QUERY_SPLIT, (String)Arrays.toString(resultSplits));
        conf = TestHiveDruidQueryBasedInputFormat.createPropertiesQuery("sample_datasource", "select", SELECT_QUERY);
        resultSplits = (HiveDruidSplit[])method1.invoke((Object)input, conf);
        TestHiveDruidQueryBasedInputFormat.assertEquals((String)SELECT_QUERY_SPLIT, (String)Arrays.toString(resultSplits));
    }

    private static Configuration createPropertiesQuery(String dataSource, String queryType, String jsonQuery) {
        Configuration conf = new Configuration();
        conf.set("mapreduce.input.fileinputformat.inputdir", "/my/dir");
        conf.set(HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS.varname, "localhost:8082");
        conf.set("druid.datasource", dataSource);
        conf.set("druid.query.json", jsonQuery);
        conf.set("druid.query.type", queryType);
        conf.setBoolean(HiveConf.ConfVars.HIVE_DRUID_SELECT_DISTRIBUTE.varname, false);
        return conf;
    }
}

