/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.listener.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParseException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.common.utils.ServletResourceUtils;
import org.apache.hive.druid.io.druid.server.listener.resource.ListenerHandler;

public abstract class AbstractListenerHandler<ObjType>
implements ListenerHandler {
    private static final Logger LOG = new Logger(AbstractListenerHandler.class);
    private final TypeReference<ObjType> inObjTypeRef;

    public AbstractListenerHandler(TypeReference<ObjType> inObjTypeRef) {
        this.inObjTypeRef = inObjTypeRef;
    }

    @Override
    public final Response handlePOST(InputStream inputStream, ObjectMapper mapper, String id) {
        try {
            Object o = this.post(ImmutableMap.of(id, mapper.readValue(inputStream, this.inObjTypeRef)));
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity(o).build();
        }
        catch (JsonParseException | JsonMappingException e) {
            LOG.debug(e, "Bad request", new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(e)).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error handling request", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @Override
    public final Response handlePOSTAll(InputStream inputStream, final ObjectMapper mapper) {
        Object returnObj;
        ImmutableMap inObjMap;
        try {
            Map<String, Object> tempMap = mapper.readValue(inputStream, new TypeReference<Map<String, Object>>(){});
            inObjMap = ImmutableMap.copyOf(Maps.transformValues(tempMap, new Function<Object, ObjType>(){

                @Override
                public ObjType apply(Object input) {
                    return mapper.convertValue(input, AbstractListenerHandler.this.inObjTypeRef);
                }
            }));
        }
        catch (IOException ex) {
            LOG.debug(ex, "Bad request", new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(ex)).build();
        }
        try {
            returnObj = this.post(inObjMap);
        }
        catch (Exception e) {
            LOG.error(e, "Error handling request", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
        if (returnObj == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity(returnObj).build();
    }

    @Override
    public final Response handleGET(String id) {
        try {
            Object returnObj = this.get(id);
            if (returnObj == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)returnObj).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error handling get request for [%s]", id);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @Override
    public final Response handleGETAll() {
        try {
            Map<String, ObjType> all = this.getAll();
            if (all == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok(all).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error getting all", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @Override
    public final Response handleDELETE(String id) {
        try {
            Object returnObj = this.delete(id);
            if (returnObj == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity(returnObj).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error in processing delete request for [%s]", id);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @Override
    public final void use_AbstractListenerHandler_instead() {
    }

    @Nullable
    protected abstract Object delete(String var1);

    @Nullable
    protected abstract Object get(String var1);

    @Nullable
    protected abstract Map<String, ObjType> getAll();

    @Nullable
    public abstract Object post(Map<String, ObjType> var1) throws Exception;
}

