/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.RE;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.audit.AuditInfo;
import org.apache.hive.druid.io.druid.common.utils.ServletResourceUtils;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.server.lookup.cache.LookupCoordinatorManager;

@Path(value="/druid/coordinator/v1/lookups")
public class LookupCoordinatorResource {
    private static final Logger LOG = new Logger(LookupCoordinatorResource.class);
    private final LookupCoordinatorManager lookupCoordinatorManager;
    private final ObjectMapper smileMapper;
    private final ObjectMapper jsonMapper;

    @Inject
    public LookupCoordinatorResource(LookupCoordinatorManager lookupCoordinatorManager, @Smile ObjectMapper smileMapper, @Json ObjectMapper jsonMapper) {
        this.smileMapper = smileMapper;
        this.jsonMapper = jsonMapper;
        this.lookupCoordinatorManager = lookupCoordinatorManager;
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response getTiers(@DefaultValue(value="false") @QueryParam(value="discover") boolean discover) {
        try {
            if (discover) {
                return Response.ok().entity(this.lookupCoordinatorManager.discoverTiers()).build();
            }
            Map<String, Map<String, Map<String, Object>>> knownLookups = this.lookupCoordinatorManager.getKnownLookups();
            if (knownLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity(knownLookups.keySet()).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error getting list of lookups", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response updateAllLookups(InputStream in, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            Map<String, Map<String, Map<String, Object>>> map;
            boolean isSmile = "application/x-jackson-smile".equals(req.getContentType());
            ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
            try {
                map = mapper.readValue(in, new TypeReference<Map<String, Map<String, Map<String, Object>>>>(){});
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(e)).build();
            }
            if (this.lookupCoordinatorManager.updateLookups(map, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity(map).build();
            }
            throw new RuntimeException("Unknown error updating configuration");
        }
        catch (Exception e) {
            LOG.error(e, "Error creating new lookups", new Object[0]);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @DELETE
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}/{lookup}")
    public Response deleteLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty(lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new IAE("`lookup` required", new Object[0]))).build();
            }
            if (this.lookupCoordinatorManager.deleteLookup(tier, lookup, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error deleting lookup [%s]", lookup);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}/{lookup}")
    public Response createOrUpdateLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, InputStream in, @Context HttpServletRequest req) {
        try {
            Map<String, Object> lookupSpec;
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty(lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new IAE("`lookup` required", new Object[0]))).build();
            }
            boolean isSmile = "application/x-jackson-smile".equals(req.getContentType());
            ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
            try {
                lookupSpec = mapper.readValue(in, new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(e)).build();
            }
            if (this.lookupCoordinatorManager.updateLookup(tier, lookup, lookupSpec, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            throw new RuntimeException("Unknown error updating configuration");
        }
        catch (Exception e) {
            LOG.error(e, "Error updating tier [%s] lookup [%s]", tier, lookup);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}/{lookup}")
    public Response getSpecificLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup) {
        try {
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty(lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`lookup` required"))).build();
            }
            Map<String, Object> map = this.lookupCoordinatorManager.getLookup(tier, lookup);
            if (map == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.sanitizeException(new RE("lookup [%s] not found", lookup))).build();
            }
            return Response.ok().entity(map).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error getting lookup [%s]", lookup);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}")
    public Response getSpecificTier(@PathParam(value="tier") String tier) {
        try {
            if (Strings.isNullOrEmpty(tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ServletResourceUtils.sanitizeException(new NullPointerException("`tier` required"))).build();
            }
            Map<String, Map<String, Map<String, Object>>> map = this.lookupCoordinatorManager.getKnownLookups();
            if (map == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.sanitizeException(new RE("No lookups found", new Object[0]))).build();
            }
            Map<String, Map<String, Object>> tierLookups = map.get(tier);
            if (tierLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(ServletResourceUtils.sanitizeException(new RE("Tier [%s] not found", tier))).build();
            }
            return Response.ok().entity(tierLookups.keySet()).build();
        }
        catch (Exception e) {
            LOG.error(e, "Error getting tier [%s]", tier);
            return Response.serverError().entity(ServletResourceUtils.sanitizeException(e)).build();
        }
    }
}

